<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

/*function dd( $value ) {
	echo '<pre style="direction: ltr; background: #fefff4; border: 1px solid #fff1d6; padding: 5px; margin: 10px;">';
	var_dump( $value );
	echo '</pre>';
}*/

/**
 * Update option by given key
 *
 * @param string $key
 *
 * @param bool $sanitize
 *
 * @internal param $options
 */
function wast_update_option( $key, $sanitize = true ) {
	$options = get_option( 'wast_options' );

	if ( isset( $_POST[ $key ] ) && ! empty( $_POST[ $key ] ) ) {
		$options[ $key ] = $sanitize ? sanitize_text_field( $_POST[ $key ] ) : $_POST[ $key ];
	} else {
		if ( array_key_exists( $key, $options ) ) {
			unset( $options[ $key ] );
		}
	}

	update_option( 'wast_options', $options );
}

/**
 * Get option by given key
 *
 * @param $key
 * @param null|string $return
 *
 * @return null
 */
function wast_get_option( $key, $return = '' ) {
	$options = get_option( 'wast_options' );

	if ( $options ) {
		if ( array_key_exists( $key, $options ) ) {
			return $options[ $key ];
		}
	}

	return $return;
}

/**
 * Get user bought product (woocommerce)
 * @return array
 */
function wast_get_customer_bought_products() {
	$product_ids = array();

	$user_id = get_current_user_id();

	if ( ! $user_id ) {
		return $product_ids;
	}

	$current_user   = wp_get_current_user();
	$customer_email = $current_user->email;
	$args           = array(
		'post_type'      => 'product',
		'posts_per_page' => - 1
	);
	$loop           = new WP_Query( $args );

	if ( $loop->have_posts() ) {
		while ( $loop->have_posts() ) : $loop->the_post();
			$_product = wc_get_product( $loop->post->ID );
			if ( wc_customer_bought_product( $customer_email, $user_id, $_product->get_id() ) ) {
				$product_ids[] = $_product->get_id();
			}
		endwhile;
	}
	wp_reset_postdata();

	return $product_ids;
}

/**
 * Get product purchase date by product id
 *
 * @param $id
 *
 * @return bool|false|int
 */
function wast_get_product_purchase_date( $id ) {
	$uid = get_current_user_id();

	$orders = get_posts( array(
		'posts_per_page' => - 1,
		'meta_key'       => '_customer_user',
		'meta_value'     => $uid,
		'post_type'      => 'shop_order',
		'post_status'    => 'wc-completed'
	) );

	if ( ! $orders ) {
		return false;
	}

	$all_ordered_product = array();

	foreach ( $orders as $order => $data ) {
		$order_data = new WC_Order( $data->ID );
		foreach ( $order_data->get_items() as $key => $item ) {
			$all_ordered_product[ $item['product_id'] ] = $data->post_date;
		}
	}
	if ( isset( $all_ordered_product[ $id ] ) ) {
		return strtotime( $all_ordered_product[ $id ] );
	} else {
		return false;
	}
}

/**
 * Check user purchased products and expiration time for woocommerce
 *
 * @param $product_id
 *
 * @return bool
 */
function wast_is_customer_bought_product( $product_id ) {
	if ( wast_get_option( 'wc-support' ) && ! empty( $product_id ) ) {
		$customer_products = wast_get_customer_bought_products();
		if ( sizeof( $customer_products ) ) {
			$product_exp_time = get_post_meta( $product_id, '_wast_product_exp_time', true );
			if ( wast_get_option( 'expiration-time' ) == 'limilted' ) {
				if ( $product_exp_time ) {
					if ( wast_get_product_purchase_date( $product_id ) + ( $product_exp_time * 86400 ) < time() ) {
						return false;
					}
				}
			} else {
				if ( ! wast_get_product_purchase_date( $product_id ) ) {
					return false;
				}
			}
		}
	}

	return true;
}

/**
 * Get user open tickets count
 * @return int
 */
function wast_get_user_open_tickets() {
	$terms = wast_get_user_ticket_types();

	if ( $terms ) {
		$term_ids = array();
		foreach ( $terms as $term ) {
			$term_ids[] = $term->term_id;
		}

		$args  = array(
			'post_type'      => WAST_Ticket_CPT::get_slug(),
			'posts_per_page' => - 1,
			'post_status'    => 'open',
			'tax_query'      => array(
				array(
					'taxonomy' => WAST_Ticket_Type_Tax::get_slug(),
					'field'    => 'term_id',
					'terms'    => $term_ids,
				),
			),
		);
		$posts = new WP_Query( $args );
		$count = $posts->found_posts;

		return $count;
	}

	return 0;
}

/**
 * Get current user ticket types
 * @return array
 */
function wast_get_user_ticket_types() {
	$user_id    = get_current_user_id();
	$user       = get_userdata( $user_id );
	$user_email = $user->user_email;

	global $wpdb;
	$terms = $wpdb->get_results(
		$wpdb->prepare(
			"SELECT `term_id` FROM `$wpdb->termmeta` WHERE `meta_key` = '_wast_recipient_email' AND `meta_value` = %s", $user_email
		)
	);

	$term_ids = array();
	if ( $terms ) {
		foreach ( $terms as $term ) {
			$term_ids[] = $term->term_id;
		}
	}

	return $term_ids;
}

/**
 * Get all open tickets count
 * @return int
 */
function wast_get_all_open_tickets() {
	$args  = array(
		'post_type'      => 'ticket',
		'posts_per_page' => - 1,
		'post_status'    => 'open',
	);
	$posts = new WP_Query( $args );
	$count = $posts->found_posts;

	return $count;
}

/**
 * Sort Multi-dimensional Array by Value
 *
 * @param $array
 * @param $key
 * https://stackoverflow.com/questions/2699086/sort-multi-dimensional-array-by-value
 */
function wast_aasort( &$array, $key ) {
	$sorter = array();
	$ret    = array();
	reset( $array );
	foreach ( $array as $ii => $va ) {
		$sorter[ $ii ] = $va[ $key ];
	}
	asort( $sorter );
	foreach ( $sorter as $ii => $va ) {
		$ret[ $ii ] = $array[ $ii ];
	}
	$array = $ret;
}

/**
 * Get expiration time of customer bought product
 *
 * @param $product_id
 *
 * @return bool|int|mixed
 */
function wast_get_exp_time( $product_id ) {
	if ( ! $product_id ) {
		return false;
	}

	$product_exp_time = get_post_meta( $product_id, '_wast_product_exp_time', true );
	if ( ! $product_exp_time ) {
		return false;
	}

	$product_exp_time = $product_exp_time * 86400;
	$purchase_date    = wast_get_product_purchase_date( $product_id );
	$product_exp_time = $purchase_date + $product_exp_time;

	return $product_exp_time;
}

/**
 * Change upload directory for ticket attachment files
 *
 * @param $args
 *
 * @return mixed
 * @hooked in handle_upload function (WAST_Ticket_Panel class)
 */
function wast_alter_the_upload_dir( $args ) {
	$y = date( 'Y', time() );
	$m = date( 'm', time() );

	$custom_dir = '/' . $y . '/' . $m;
	$new_dir    = '/wast_uploads' . $custom_dir;

	$args['path']   = str_replace( $args['subdir'], '', $args['path'] );
	$args['url']    = str_replace( $args['subdir'], '', $args['url'] );
	$args['subdir'] = $new_dir;
	$args['path']   .= $new_dir;
	$args['url']    .= $new_dir;

	return $args;
}

/**
 * Get all ticket types as array
 * @return array
 */
function wast_get_file_ext_white_list() {
	$file_ext = trim( wast_get_option( 'file-ext' ) );
	$file_ext = str_replace( ' ', '', $file_ext );

	if ( ! $file_ext ) {
		return array();
	}

	$file_ext = explode( ',', $file_ext );

	return $file_ext;
}

/**
 * Get file MIME type by extension
 * @return array
 */
function wast_get_mimes() {
	$mimes = WAST_INC_PATH . 'mimetypes.json';
	$mimes = json_decode( file_get_contents( $mimes ) );

	$list = array();

	$white_list = wast_get_file_ext_white_list();
	if ( sizeof( $white_list ) ) {
		foreach ( $white_list as $item ) {
			if ( isset( $mimes->$item ) ) {
				$list[ $item ] = $mimes->$item;
			}
		}
	}

	return $list;
}

/**
 * Get ticket replies count
 *
 * @param $ticket_id
 *
 * @return int
 */
function wast_get_reply_count( $ticket_id ) {
	global $wpdb;
	$reply_count = $wpdb->get_var( $wpdb->prepare( "
	SELECT COUNT(*) FROM `$wpdb->postmeta` WHERE `post_id` = %d 
	AND `meta_key` LIKE '_wast_ticket_reply%'", $ticket_id ) );

	return intval( $reply_count );
}

/**
 * Get all replies for specific ticket by $ticket_id
 *
 * @param $ticket_id
 *
 * @return array
 */
function wast_get_ticket_replies( $ticket_id ) {
	global $wpdb;
	$replies = $wpdb->get_results( $wpdb->prepare( "
	SELECT `meta_value` FROM `$wpdb->postmeta` WHERE `post_id` = %d 
    AND `meta_key` LIKE '_wast_ticket_reply%'", $ticket_id ) );

	$values = array();
	if ( sizeof( $replies ) ) {
		foreach ( $replies as $reply ) {
			if ( isset( $reply->meta_value ) ) {
				$values[] = $reply->meta_value;
			}
		}
	}

	$r = array();
	if ( sizeof( $values ) ) {
		foreach ( $values as $value ) {
			array_push( $r, unserialize( $value ) );
		}
	}

	return $r;
}

/**
 * Get passed time
 *
 * @param $ts
 *
 * @return string
 */
function wast_time_ago( $ts ) {
	$eTime = time() - $ts;
	if ( $eTime < 1 ) {
		return "هم اکنون";
	}
	$arr = array(
		12 * 30 * 24 * 60 * 60 => "سال",
		30 * 24 * 60 * 60      => "ماه",
		24 * 60 * 60           => "روز",
		60 * 60                => "ساعت",
		60                     => "دقیقه",
		1                      => "ثانیه"
	);
	foreach ( $arr as $secs => $str ) {
		$d = $eTime / $secs;
		if ( $d >= 1 ) {
			return round( $d ) . ' ' . $str . ' قبل';
		}
	}
}

/**
 * Set new status for post
 *
 * @param $new_status
 * @param $post_id
 *
 * @return false|int
 */
function wast_set_post_status( $new_status, $post_id ) {
	global $wpdb;
	$query = $wpdb->query( $wpdb->prepare( "
	UPDATE `$wpdb->posts` SET `post_status` = %s
	WHERE `ID` = %d", $new_status, $post_id ) );

	return $query;
}

/**
 * Get all user ticket count
 * @return int
 */
function wast_get_ticket_count() {
	global $wpdb;
	$author_id = get_current_user_id();
	$statuses  = array_keys( wast_get_ticket_statuses() );

	if ( isset( $_GET['status'] ) && ! empty( $_GET['status'] ) && in_array( $_GET['status'], $statuses ) ) {
		$status = esc_sql( $_GET['status'] );

		$all_tickets = $wpdb->get_results( $wpdb->prepare( "
        SELECT * FROM `$wpdb->posts` 
        WHERE `post_author` = %d 
        AND `post_status` != 'trash'
        AND `post_type` = 'ticket' 
        AND `post_status` = %s", $author_id, $status ) );
	} else {
		$all_tickets = $wpdb->get_results( $wpdb->prepare( "
        SELECT * FROM `$wpdb->posts` 
        WHERE `post_author` = %d 
        AND `post_status` != 'trash'
        AND `post_type` = 'ticket'", $author_id ) );
	}

	if ( $all_tickets ) {
		return sizeof( $all_tickets );
	}

	return 0;
}

/**
 * Get all user tickets
 * @return array|bool|null|object
 */
function wast_get_user_tickets() {
	global $wpdb;

	$uid = get_current_user_id();

	$page_number = 1;
	if ( isset( $_GET['page-number'] ) && ctype_digit( $_GET['page-number'] ) ) {
		$page_number = $_GET['page-number'];
	}

	$dokan_term1     = "";
	$dokan_term2     = "";
	$dokan_query     = "";
	$seller_products = wast_get_seller_products( $uid );
	if ( $seller_products ) {
		$term = wast_get_option( 'dokan-ticket-type' );
		if ( $term ) {
			$dokan_term1 = "INNER JOIN $wpdb->term_relationships tr ON $wpdb->posts.ID=tr.object_id";
			$dokan_term2 = "AND tr.term_taxonomy_id = {$term}";
		}

		$in          = "(" . implode( ", ", $seller_products ) . ")";
		$dokan_query = "OR m2.meta_key = '_wast_ticket_product_id' AND m2.meta_value IN {$in}";
	}

	$orderby_option = wast_get_option( 'orderby' );
	$orderby        = "$wpdb->posts.post_date DESC";
	if ( $orderby_option == 'date-answered' ) {
		$orderby = "m1.meta_value DESC";
	}

	$posts_per_page = wast_get_option( 'posts-per-page' ) ? wast_get_option( 'posts-per-page' ) : 20;
	$offset         = ( $page_number - 1 ) * $posts_per_page;

	$statuses = array_keys( wast_get_ticket_statuses() );
	if ( isset( $_GET['status'] ) && ! empty( $_GET['status'] ) && in_array( $_GET['status'], $statuses ) ) {
		$status  = esc_sql( $_GET['status'] );
		$tickets = $wpdb->get_results( $wpdb->prepare( "
        SELECT * FROM $wpdb->posts 
        INNER JOIN $wpdb->postmeta m1 ON $wpdb->posts.ID=m1.post_id 
        INNER JOIN $wpdb->postmeta m2 ON $wpdb->posts.ID=m2.post_id 
        {$dokan_term1} 
        WHERE $wpdb->posts.post_author = %d 
        AND $wpdb->posts.post_type = 'ticket' 
        AND `post_status` = %s 
        AND m1.meta_key = '_wast_ticket_last_reply_date' 
        {$dokan_query} 
        {$dokan_term2} 
        GROUP BY $wpdb->posts.ID 
        ORDER BY {$orderby} 
        LIMIT %d OFFSET %d", $uid, $status, $posts_per_page, $offset ) );
	} else {
		$tickets = $wpdb->get_results( $wpdb->prepare( "
        SELECT * FROM $wpdb->posts 
        INNER JOIN $wpdb->postmeta m1 ON $wpdb->posts.ID=m1.post_id 
        INNER JOIN $wpdb->postmeta m2 ON $wpdb->posts.ID=m2.post_id 
        {$dokan_term1} 
        WHERE $wpdb->posts.post_author = %d 
        AND $wpdb->posts.post_type = 'ticket' 
        AND $wpdb->posts.post_status != 'trash' 
        AND m1.meta_key = '_wast_ticket_last_reply_date' 
        {$dokan_query} 
        {$dokan_term2} 
        GROUP BY $wpdb->posts.ID 
        ORDER BY {$orderby} 
        LIMIT %d OFFSET %d", $uid, $posts_per_page, $offset ) );
	}

	if ( $tickets ) {
		return $tickets;
	}

	return false;
}

/**
 * Check user role is dokan seller
 *
 * @param $user_id
 *
 * @return bool
 */
function wast_is_user_seller( $user_id ) {
	if ( ! in_array( 'dokan-lite/dokan.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		return false;
	}

	if ( ! intval( $user_id ) ) {
		return false;
	}

	$user_info = get_userdata( $user_id );
	$roles     = $user_info->roles;

	return in_array( 'seller', $roles ) ? true : false;
}

/**
 * Get dokan seller products
 *
 * @param $seller_id
 *
 * @return array|null|object
 */
function wast_get_seller_products( $seller_id ) {
	if ( ! intval( $seller_id ) ) {
		return null;
	}

	global $wpdb;

	$products = $wpdb->get_results( $wpdb->prepare( "
	SELECT `ID` FROM `$wpdb->posts` 
	WHERE `post_type` = 'product' 
	AND `post_author` = %d 
	AND `post_status` = 'publish'
	", $seller_id ) );

	$product_IDs = array();
	if ( count( $products ) ) {
		foreach ( $products as $product ) {
			array_push( $product_IDs, $product->ID );
		}

		return $product_IDs;
	}

	return null;
}

/**
 * Get dokan dashboard page ID
 * @return bool|mixed
 */
function wast_get_dokan_dashboard_page() {
	if ( ! in_array( 'dokan-lite/dokan.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		return false;
	}

	$dokan_pages = get_option( 'dokan_pages' );

	if ( ! $dokan_pages ) {
		return false;
	}

	if ( is_array( $dokan_pages ) ) {
		if ( array_key_exists( 'dashboard', $dokan_pages ) ) {
			return $dokan_pages['dashboard'];
		}
	}

	return false;
}

/**
 * Get ticket page url
 *
 * @param $uid
 *
 * @return false|string
 */
function wast_get_ticket_page_url( $uid ) {
	$ticket_page = wast_get_option( 'ticket-page' );

	if ( wast_get_dokan_dashboard_page() && wast_is_user_seller( $uid ) ) {
		$p_id = wast_get_dokan_dashboard_page();
	} else {
		$p_id = get_option( 'woocommerce_myaccount_page_id' );
	}
	$ticket_url = $ticket_page ? get_permalink( $ticket_page ) : trailingslashit( get_permalink( $p_id ) ) . 'tickets';

	return $ticket_url;
}