<div class="wast-wrapper">
    <h3 class="wast-title wast-clearfix">
        <span>همه تیکت‌ها</span>
        <a href="<?php echo add_query_arg( array( 'action' => 'new' ), remove_query_arg( array( 'page-number',
			'status' ) ) ); ?>" class="wast-btn wast-btn-primary wast-btn-sm wast-float-left">ارسال تیکت جدید</a>
    </h3>
    <hr class="wast-hr">
    <div class="wast-filter wast-clearfix">
        <form id="wast-filter" method="get">
            <select name="status" class="wast-custom-select">
                <option value="all">همه وضعیت‌ها</option>
				<?php
				foreach ( wast_get_ticket_statuses() as $key => $value ) {
					$status = 'all';
					if ( isset( $_GET['status'] ) && ! empty( $_GET['status'] ) && in_array( $_GET['status'], array_keys( wast_get_ticket_statuses() ) ) ) {
						$status = $_GET['status'];
					}
					$selected = $status == $key ? 'selected' : '';
					echo '<option value="' . $key . '" ' . $selected . '>' . $value . '</option>';
				}
				?>
            </select>
            <input type="submit" class="wast-btn wast-btn-info" value="فیلتر">
        </form>
    </div>
	<?php
	$tickets = wast_get_user_tickets();

	if ( $tickets && sizeof( $tickets ) ) {
		?>
        <table class="wast-tickets-table wast-table wast-table-striped wast-table-bordered">
            <thead class="wast-thead-light">
            <tr>
                <th class="wast-title-column" scope="col">عنوان</th>
                <th class="wast-product-column" scope="col">محصول</th>
                <th class="wast-status-column" scope="col">وضعیت</th>
                <th class="wast-date-column" scope="col">تاریخ</th>
            </tr>
            </thead>
            <tbody>
			<?php
			foreach ( $tickets as $ticket ) {
				?>
                <tr>
                    <td class="wast-title-column">
                        <a href="<?php echo add_query_arg( array( 'action'    => 'reply',
						                                          'ticket_id' => $ticket->ID ), remove_query_arg( array( 'page-number',
							'status' ) ) ); ?>">
							<?php echo $ticket->post_title; ?>
                        </a>
                        <p>
							<?php
							$user_id   = $ticket->post_author;
							$user_info = get_userdata( $user_id );
							echo $user_info->display_name;
							?>
                        </p>
                    </td>
                    <td class="wast-product-column">
						<?php
						$product_id = get_post_meta( $ticket->ID, '_wast_ticket_product_id', true );
						if ( is_numeric( $product_id ) ) {
							echo '<a href="' . get_permalink( $product_id ) . '" target="_blank">' . get_the_title( $product_id ) . '</a>';
						} else {
							echo $product_id;
						}
						?>
                    </td>
                    <td class="wast-status-column">
						<?php
						$status = get_post_status( $ticket->ID );
						foreach ( wast_get_ticket_statuses() as $key => $value ) {
							if ( $status == $key ) {
								echo '<span class="wast-badge wast-badge-' . $key . '">' . $value . '</span>';
								break;
							}
						}
						?>
                    </td>
                    <td class="wast-date-column">
                        <p>
                            <span>ارسال: </span>
                            <time class="wast-text-muted" title="<?php echo date_i18n( 'Y/m/d H:i:s', get_the_time( 'U', $ticket->ID ) ); ?>">
								<?php echo wast_time_ago( get_the_time( 'U', $ticket->ID ) ); ?>
                            </time>
                        </p>
                        <p>
							<?php
							$replies = wast_get_ticket_replies( $ticket->ID );
							if ( sizeof( $replies ) ) {
								echo '<span>آخرین پاسخ: </span>';
								echo '<time class="wast-text-muted" title="' . date_i18n( 'Y/m/d H:i:s', $replies[ sizeof( $replies ) - 1 ]['date'] ) . '">';
								echo wast_time_ago( $replies[ sizeof( $replies ) - 1 ]['date'] );
								echo '</bdi>';
								echo '<span>(' . sizeof( $replies ) . ')</span>';
							}
							?>
                        </p>
                    </td>
                </tr>
				<?php
			}
			wp_reset_query();
			?>
            </tbody>
        </table>
		<?php
		$page_number = 1;
		if ( isset( $_GET['page-number'] ) && ctype_digit( $_GET['page-number'] ) ) {
			$page_number = $_GET['page-number'];
		}
		$posts_per_page = wast_get_option( 'posts-per-page' ) ? wast_get_option( 'posts-per-page' ) : 20;

		$big  = 999999999;
		$args = array(
			'base' => preg_replace('/\?.*/', '', get_pagenum_link()) . '%_%',
			'format'    => '?page-number=%#%',
			'total'     => ceil( count( wast_get_user_tickets() ) / $posts_per_page ),
			'current'   => max( 1, $page_number ),
			'show_all'  => false,
			'prev_next' => false,
			'type'      => 'list',
		);
		echo paginate_links( $args );
		?>
		<?php
	} else {
		echo '<div class="wast-alert wast-alert-info">موردی یافت نشد!</div>';
	}
	?>
</div>