<?php
/*
Plugin Name: تیکت پشتیبانی وردپرس
Plugin URI: https://wordpress.com
Description: یک سیستم تیکت فوق العاده
Version: 13.1.0
Author: وردپرس
Author URI: https://wordpress.com
*/

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

/**
 * Plugin base class
 */
final class WAST_Support_Ticket {

	/**
	 * Single instance of class
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Get class single instance
	 * @return null|WAST_Support_Ticket
	 */
	public static function get_instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Create a new object
	 * WAST_Support_Ticket constructor.
	 */
	public function __construct() {

		$this->define_constants();

		register_activation_hook( __FILE__, array( $this, 'plugin_activation' ) );
		register_deactivation_hook( __FILE__, 'plugin_deactivation' );

		add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'add_action_links' ) );

		add_action( 'wast_auto_close_ticket_event', array( $this, 'auto_close_ticket' ) );

		if ( function_exists( '__autoload' ) ) {
			spl_autoload_register( '__autoload' );
		}
		spl_autoload_register( array( $this, 'autoload' ) );

		$this->load_assets();

		$this->_include();
	}

	/**
	 * Define constants for use entire project
	 */
	private function define_constants() {
		define( 'WAST_VERSION', '13.1.0' );

		define( 'WAST_PATH', trailingslashit( plugin_dir_path( __FILE__ ) ) );
		define( 'WAST_URL', trailingslashit( plugin_dir_url( __FILE__ ) ) );

		define( 'WAST_INC_PATH', trailingslashit( WAST_PATH . 'includes' ) );
		define( 'WAST_CLASS_PATH', trailingslashit( WAST_PATH . 'classes' ) );
		define( 'WAST_TPL_PATH', trailingslashit( WAST_PATH . 'templates' ) );

		define( 'WAST_CSS_URL', trailingslashit( WAST_URL . 'assets/css' ) );
		define( 'WAST_JS_URL', trailingslashit( WAST_URL . 'assets/js' ) );
		define( 'WAST_IMG_URL', trailingslashit( WAST_URL . 'assets/images' ) );
	}

	/**
	 * Include files
	 */
	private function _include() {
		require_once( ABSPATH . 'wp-admin/includes/screen.php' );
		include( WAST_INC_PATH . 'functions.php' );
		include( WAST_INC_PATH . 'hooks.php' );
		include( WAST_INC_PATH . 'ajax.php' );
		include( WAST_INC_PATH . 'ticket-cpt.php' );
		include( WAST_INC_PATH . 'ticket-type-tax.php' );
		include( WAST_INC_PATH . 'pre-answer-cpt.php' );
		include( WAST_INC_PATH . 'admin-menu.php' );
		include( WAST_INC_PATH . 'product-mtb.php' );
		include( WAST_INC_PATH . 'user-mtb.php' );
		include( WAST_INC_PATH . 'ticket-panel.php' );
		include( WAST_INC_PATH . 'dokan-panel.php' );
		include( WAST_INC_PATH . 'shortcodes.php' );
	}

	/**
	 * This function call when plugin is activate
	 */
	public function plugin_activation() {
		if ( get_option( 'wast_version' ) != WAST_VERSION ) {
			update_option( 'wast_version', WAST_VERSION );
		}

		$this->insert_default_options();

		if ( ! wp_next_scheduled( 'wast_auto_close_ticket_event' ) ) {
			wp_schedule_event( strtotime( date( 'Y-m-d 23:00:00' ) ), 'daily', 'wast_auto_close_ticket_event' );
		}
	}

	/**
	 * This function call when plugin is deactivate
	 */
	public function plugin_deactivation() {
		wp_clear_scheduled_hook( 'wast_auto_close_ticket_event' );
	}

	/**
	 * Auto include all class files in classes path entire project
	 *
	 * @param $class
	 */
	public function autoload( $class ) {
		if ( false !== strpos( $class, 'WAST_' ) ) {
			$class_file = WAST_CLASS_PATH . 'class-' . str_replace( '_', '-', substr( strtolower( $class ), 5 ) ) . '.php';
			if ( is_file( $class_file ) && file_exists( $class_file ) ) {
				include_once $class_file;
			}
		}
	}

	/**
	 * Applied to the list of links to display on the plugins page (beside the activate/deactivate links)
	 *
	 * @param $links
	 *
	 * @return array
	 */
	public function add_action_links( $links ) {
		$links[] = '<a href="' . admin_url( 'edit.php?post_type=ticket&page=wast-options' ) . '">تنظیمات</a>';

		return $links;
	}

	/**
	 * Insert default options for plugin in database
	 */
	private function insert_default_options() {
		if ( ! get_option( 'wast_options' ) ) {
			$options = array(
				'posts-per-page'       => 10,
				'orderby'              => 'date-created',
				'show-icon'            => '1',
				'ticket-order'         => 'desc',
				'active-upload'        => '1',
				'file-max-size'        => '1',
				'active-notifications' => '1',
				'email-subject'        => 'تیکت پشتیبانی جدید',
				'email-sender'         => $_SERVER['HTTP_HOST'] && isset( $_SERVER['HTTP_HOST'] ) ? 'noreply@' . $_SERVER['HTTP_HOST'] : '',
			);

			update_option( 'wast_options', $options );
		}
	}

	/**
	 * Change old ticket status to closed
	 */
	public function auto_close_ticket() {
		$period = wast_get_option( 'auto-close-period' );
		if ( ! intval( $period ) ) {
			return false;
		}

		$period_s = $period * 86400;

		$args  = array(
			'post_type'      => 'ticket',
			'posts_per_page' => - 1,
			'post_status'    => array( 'open', 'in_progress', 'answered' ),
			'meta_query'     => array(
				array(
					'key'     => '_wast_ticket_last_reply_date',
					'value'   => time() - $period_s,
					'compare' => '<',
				),
			),
		);
		$posts = new WP_Query( $args );

		if ( $posts->have_posts() ) {
			while ( $posts->have_posts() ) {
				$posts->the_post();
				$post_ids[] = $posts->post->ID;

				wast_set_post_status( 'closed', $posts->post->ID );
			}
		}
	}

	/**
	 * Load CSS and JS files in front-end
	 */
	public function load_assets() {
		add_action( 'wp_enqueue_scripts', array( $this, 'load_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'load_admin_scripts' ) );

		$this->wp_footer();
		$this->wp_head();
		$this->admin_footer();
	}

	/**
	 * Register CSS and JS file for front-end
	 */
	public function load_scripts() {
		wp_register_style( 'wast-styles', WAST_CSS_URL . 'styles.css', null, WAST_VERSION );
		wp_enqueue_style( 'wast-styles' );
		wp_register_script( 'wast-scripts', WAST_JS_URL . 'scripts.js', array( 'jquery' ), WAST_VERSION, true );
		wp_enqueue_script( 'wast-scripts' );
		wp_localize_script( 'wast-scripts', 'wast_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	}

	/**
	 * Register CSS and JS file for back-end
	 */
	public function load_admin_scripts() {
		wp_enqueue_media();

		wp_register_style( 'wast-styles', WAST_CSS_URL . 'admin-styles.css', null, WAST_VERSION );
		wp_enqueue_style( 'wast-styles' );
		wp_register_script( 'wast-scripts', WAST_JS_URL . 'admin-scripts.js', array( 'jquery' ), WAST_VERSION, true );
		wp_enqueue_script( 'wast-scripts' );
		wp_localize_script( 'wast-scripts', 'wast_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	}

	/**
	 * Customize head in front-end
	 */
	private function wp_head() {
		add_action( 'wp_head', function () {
			echo '<meta name="_wast_nonce" content="' . wp_create_nonce( 'ajax_nonce' ) . '">' . PHP_EOL;
			if ( wast_get_option( 'custom-css' ) ) {
				echo '<style>' . esc_html( wast_get_option( 'custom-css' ) ) . '</style>' . PHP_EOL;
			}
			if ( wast_get_option( 'support-icon-alignment' ) == 'left' ) {
				echo '<style>#wast-support-icon {right: auto !important;left: 1rem !important;}</style>' . PHP_EOL;
			}
		} );
	}

	/**
	 * Customize footer in front-end
	 */
	private function wp_footer() {
		add_action( 'wp_footer', function () {
			if ( wast_get_option( 'show-icon' ) && is_user_logged_in() ) {
				$ticket_url   = wast_get_ticket_page_url( get_current_user_id() );
				$support_icon = wast_get_option( 'support-icon' );
				$support_icon = $support_icon ? $support_icon : WAST_IMG_URL . 'chat.png';
				echo '<a href="' . add_query_arg( array( 'action' => 'new' ), $ticket_url ) . '" id="wast-support-icon"><img src="' . esc_attr( $support_icon ) . '" alt=""></a>';
			}
		}, 99 );
	}

	/**
	 * Customize footer in back-end
	 */
	private function admin_footer() {
		add_action( 'admin_footer', function () {
			$screen = get_current_screen();
			if ( $screen->base == 'post' && $screen->post_type == 'pre-answer' ) {
				?>
                <script>
                    jQuery(document).ready(function ($) {
                        var menu_posts_ticket = $('#menu-posts-ticket');
                        menu_posts_ticket.addClass('wp-has-current-submenu wp-menu-open');
                        menu_posts_ticket.find('a.menu-icon-ticket').addClass('wp-has-current-submenu wp-menu-open');
                        $('a[href="<edit.php?post_type=pre-answer"]').parentsUntil('ul.wp-submenu').addClass('current');
                    });
                </script>
				<?php
			}
		} );
	}

	public function __clone() {
	}

	public function __wakeup() {
	}
}

WAST_Support_Ticket::get_instance();