<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

require_once "tmfile/style-functions.php";
require_once "tmfile/elementor/taranomelementor.php";
require_once "tmfile/elementor/helper-function.php";
add_theme_support("title-tag");
add_action("after_setup_theme", "woocommerce_support");
add_action("wp_enqueue_scripts", "yadgiri_scripts");
define("RWMBD_URL", trailingslashit(get_stylesheet_directory_uri() . "/meta-box"));
define("RWMBD_DIR", trailingslashit(STYLESHEETPATH . "/meta-box"));
require_once RWMBD_DIR . "meta-box.php";
require_once RWMBD_DIR . "product.php";
require_once RWMBD_DIR . "moshtari.php";
require_once RWMBD_DIR . "post.php";
add_action("init", "elai", 0);
add_filter("woocommerce_sale_flashtwo", "ds_replace_sale_text");
add_action("woocommerce_namojood", "iwp_out_of_stock_loop_woocommerce");
add_action("woocommerce_single_product_summary_3", "bbloomer_product_sold_count", 11);
if (function_exists("register_sidebar")) {
    register_sidebar(["name" => "filter", "id" => "filter", "description" => "ابزارک فيلتر", "before_widget" => "<div class=\"filter-32324\">", "after_widget" => "</div>", "before_title" => "<h4>", "after_title" => "</h4>"]);
}
if (function_exists("register_sidebar")) {
    register_sidebar(["name" => "blog", "id" => "blog", "description" => "ابزارک وبلاگ", "before_widget" => "<div class=\"blog-sider\">", "after_widget" => "</div>", "before_title" => "<h4>", "after_title" => "</h4>"]);
}
add_filter("woocommerce_get_price_html5", "func_offer_end_date", 100, 2);
add_shortcode("display_end_date", "func_offer_end_date");
define("es_THEME_VER", "1.0.0");
define("es_THEME_PATH", trailingslashit(get_template_directory()));
define("es_THEME_URI", trailingslashit(get_template_directory_uri()));
define("es_TPL_PATH", trailingslashit(es_THEME_PATH . "temp"));
define("es_WIDGET_PATH", trailingslashit(es_THEME_PATH . "widget"));
include es_WIDGET_PATH . "class-widget-blog.php";
add_action("init", "moshtari", 0);
add_action("init", "register_my_menus");
add_action("admin_enqueue_scripts", "add_admincss");
add_action("admin_enqueue_scripts", "add_admincsstwo");
require_once "tgm/tgm-plugin-registration.php";
add_action("after_setup_theme", "woocommerce_support");
add_filter("woocommerce_add_to_cart_fragments", "iconic_cart_count_fragments", 10, 1);
add_filter("excerpt_length", "wpdocs_custom_excerpt_length", 999);
add_filter("woocommerce_account_menu_items", "misha_log_history_link", 40);
add_action("init", "misha_add_endpoint");
add_action("woocommerce_account_spotlist_endpoint", "misha_my_account_endpoint_content");
include "setting/setting.php";
function woocommerce_support()
{
    add_theme_support("woocommerce");
}
function yadgiri_scripts()
{
    wp_enqueue_script("html5", get_theme_file_uri("/assets/js/html5.js"), [], "3.7.3");
    wp_script_add_data("html5", "conditional", "lt IE 9");
    wp_enqueue_script("jquery-scrollto", get_theme_file_uri("/assets/js/jquery.scrollTo.js"), ["jquery"], "2.1.2", true);
    if (is_singular() && comments_open() && get_option("thread_comments")) {
        wp_enqueue_script("comment-reply");
    }
}
function es_get_customer_bought_products()
{
    $product_ids = [];
    $user_id = get_current_user_id();
    if (!$user_id) {
        return $product_ids;
    }
    $current_user = wp_get_current_user();
    $customer_email = $current_user->email;
    $args = ["post_type" => "product", "posts_per_page" => -1, "post_status" => "publish"];
    $loop = new WP_Query($args);
    if ($loop->have_posts()) {
        while ($loop->have_posts()) {
            $loop->the_post();
            $_product = wc_get_product($loop->post->ID);
            if (wc_customer_bought_product($customer_email, $user_id, $_product->get_id())) {
                $product_ids[] = $_product->get_id();
            }
        }
    }
    wp_reset_postdata();
    return array_unique($product_ids);
}
function es_get_customer_total_order()
{
    $customer_orders = get_posts(["numberposts" => -1, "meta_key" => "_customer_user", "meta_value" => get_current_user_id(), "post_type" => ["shop_order"], "post_status" => ["wc-completed"]]);
    $total = 0;
    foreach ($customer_orders as $customer_order) {
        $order = wc_get_order($customer_order);
        $total += $order->get_total();
    }
    return $total;
}
function es_comment_count($uid)
{
    if (!$uid) {
        return 0;
    }
    global $wpdb;
    $count = $wpdb->get_var("SELECT COUNT(comment_ID) FROM " . $wpdb->comments . " WHERE user_id = \"" . $uid . "\"");
    return intval($count);
}
function elai()
{
    $labels = ["name" => _x("elai", "Post Type General Name", "elai"), "singular_name" => _x("اطلاعیه ها", "Post Type Singular Name", "elai"), "menu_name" => __("اطلاعیه ها", "elai"), "name_admin_bar" => __("اطلاعیه ها", "elai"), "archives" => __("بایگانی اطلاعیه ها", "elai"), "attributes" => __("ویژگی های اطلاعیه", "elai"), "parent_item_colon" => __("اطلاعیه والد :", "elai"), "all_items" => __("تمام اطلاعیه ها", "elai"), "add_new_item" => __("افزودن اطلاعیه جدید", "elai"), "add_new" => __("افزودن اطلاعیه", "elai"), "new_item" => __("اطلاعیه جدید", "elai"), "edit_item" => __("ویرایش اطلاعیه", "elai"), "update_item" => __("بروزرسانی اطلاعیه", "elai"), "view_item" => __("نمایش اطلاعیه", "elai"), "view_items" => __("نمایش اطلاعیه ها", "elai"), "search_items" => __("جستجو اطلاعیه", "elai"), "not_found" => __("یافت نشد", "elai"), "not_found_in_trash" => __("چیزی در سطل زباله یافت نشد", "elai"), "featured_image" => __("تصویر اطلاعیه", "elai"), "set_featured_image" => __("وارد کردن تصویر اطلاعیه", "elai"), "remove_featured_image" => __("حذف تصویر اطلاعیه", "elai"), "use_featured_image" => __("استفاده به عنوان تصویر", "elai"), "insert_into_item" => __("وارد کردن آیتم", "elai"), "uploaded_to_this_item" => __("به این مورد آپلود شد", "elai"), "items_list" => __("لیست اطلاعیه ها", "elai"), "items_list_navigation" => __("لیست اطلاعیه ها", "elai"), "filter_items_list" => __("فیلتر اطلاعیه ها", "elai")];
    $rewrite = ["slug" => "elai", "with_front" => true, "pages" => true, "feeds" => true];
    $args = ["label" => __("اطلاعیه ها", "elai"), "description" => __("بخشی برای ایجاد اطلاعیه و توضیحات انها", "elai"), "labels" => $labels, "supports" => ["title", "editor", "thumbnail"], "taxonomies" => [], "hierarchical" => false, "public" => true, "show_ui" => true, "show_in_menu" => true, "menu_position" => 6, "menu_icon" => "dashicons-smiley", "show_in_admin_bar" => true, "show_in_nav_menus" => true, "can_export" => true, "has_archive" => false, "exclude_from_search" => false, "publicly_queryable" => true, "query_var" => "elai", "rewrite" => $rewrite, "capability_type" => "page"];
    register_post_type("elai", $args);
}
function ds_replace_sale_text($text)
{
    global $product;
    $stock = $product->get_stock_status();
    $product_type = $product->get_type();
    $sale_price = 0;
    $regular_price = 0;
    if ($product_type == "variable") {
        $product_variations = $product->get_available_variations();
        foreach ($product_variations as $kay => $value) {
            if ($value["display_price"] < $value["display_regular_price"]) {
                $sale_price = $value["display_price"];
                $regular_price = $value["display_regular_price"];
            }
        }
        if ($sale_price < $regular_price && $stock != "outofstock") {
            $product_sale = intval((intval($regular_price) - intval($sale_price)) / intval($regular_price) * 100);
            if (5 < $product_sale) {
                return "" . $product_sale . "%";
            }
            if ($product_sale <= 5) {
                return "" . $product_sale . "%";
            }
        } else {
            return "";
        }
    } else {
        $regular_price = get_post_meta(get_the_ID(), "_regular_price", true);
        $sale_price = get_post_meta(get_the_ID(), "_sale_price", true);
        if (5 < $regular_price) {
            $product_sale = intval((intval($regular_price) - intval($sale_price)) / intval($regular_price) * 100);
            return " " . $product_sale . "%";
        }
        if (0 <= $regular_price && $regular_price <= 5) {
            $product_sale = intval((intval($regular_price) - intval($sale_price)) / intval($regular_price) * 100);
            return " " . $product_sale . "%";
        }
        return "";
    }
}
function iwp_out_of_stock_loop_woocommerce()
{
    global $product;
    if (!$product->is_in_stock()) {
        echo "<span class=\"outofstock-new\">" . __("ناموجود", "woocommerce") . "</span>";
    }
}
function func_offer_end_date($atts)
{
    global $post;
    $sales_price_to = get_post_meta($post->ID, "_sale_price_dates_to", true);
    if ($sales_price_to != "") {
        $sales_price_date_to = date("m/d/Y", $sales_price_to);
    }
    return $sales_price_date_to;
}
function moshtari()
{
    $labels = ["name" => _x("moshtari", "Post Type General Name", "moshtari"), "singular_name" => _x("دانشجو ها", "Post Type Singular Name", "moshtari"), "menu_name" => __("دانشجو ها", "moshtari"), "name_admin_bar" => __("دانشجو ها", "moshtari"), "archives" => __("بایگانی دانشجو ها", "moshtari"), "attributes" => __("ویژگی های دانشجو", "moshtari"), "parent_item_colon" => __("دانشجو والد :", "moshtari"), "all_items" => __("تمام دانشجو ها", "moshtari"), "add_new_item" => __("افزودن دانشجو جدید", "moshtari"), "add_new" => __("افزودن دانشجو", "moshtari"), "new_item" => __("دانشجو جدید", "moshtari"), "edit_item" => __("ویرایش دانشجو", "moshtari"), "update_item" => __("بروزرسانی دانشجو", "moshtari"), "view_item" => __("نمایش دانشجو", "moshtari"), "view_items" => __("نمایش دانشجو ها", "moshtari"), "search_items" => __("جستجو دانشجو", "moshtari"), "not_found" => __("یافت نشد", "moshtari"), "not_found_in_trash" => __("چیزی در سطل زباله یافت نشد", "moshtari"), "featured_image" => __("تصویر دانشجو", "moshtari"), "set_featured_image" => __("وارد کردن تصویر دانشجو", "moshtari"), "remove_featured_image" => __("حذف تصویر دانشجو", "moshtari"), "use_featured_image" => __("استفاده به عنوان تصویر", "moshtari"), "insert_into_item" => __("وارد کردن آیتم", "moshtari"), "uploaded_to_this_item" => __("به این مورد آپلود شد", "moshtari"), "items_list" => __("لیست دانشجو ها", "moshtari"), "items_list_navigation" => __("لیست دانشجو ها", "moshtari"), "filter_items_list" => __("فیلتر دانشجو ها", "moshtari")];
    $rewrite = ["slug" => "moshtari", "with_front" => true, "pages" => true, "feeds" => true];
    $args = ["label" => __("دانشجو ها", "moshtari"), "description" => __("بخشی برای ایجاد دانشجو و توضیحات انها", "moshtari"), "labels" => $labels, "supports" => ["title", "editor", "thumbnail"], "taxonomies" => [], "hierarchical" => false, "public" => true, "show_ui" => true, "show_in_menu" => true, "menu_position" => 5, "menu_icon" => "dashicons-admin-users", "show_in_admin_bar" => true, "show_in_nav_menus" => true, "can_export" => true, "has_archive" => false, "exclude_from_search" => false, "publicly_queryable" => true, "query_var" => "moshtari", "rewrite" => $rewrite, "capability_type" => "page"];
    register_post_type("moshtari", $args);
}
function register_my_menus()
{
    register_nav_menus(["header-menu" => __("فهرست سربرگ")]);
}
function add_admincss()
{
    wp_enqueue_style("my_admin_css", get_template_directory_uri() . "/setting/admin/css-admin.css");
}
function add_admincsstwo()
{
    wp_enqueue_style("my_admin_csstwo", get_template_directory_uri() . "/setting/admin/uicons-regular-rounded.css");
}
function iconic_cart_count_fragments($fragments)
{
    $fragments["div.header-cart-count"] = "<div class=\"header-cart-count\">" . WC()->cart->get_cart_contents_count() . "</div>";
    return $fragments;
}
function wpdocs_custom_excerpt_length($length)
{
    return 20;
}
function misha_log_history_link($menu_links)
{
    $menu_links = array_slice($menu_links, 0, 3, true) + ["spotlist" => "دوره های من"] + array_slice($menu_links, 3, NULL, true);
    return $menu_links;
}
function misha_add_endpoint()
{
    add_rewrite_endpoint("spotlist", EP_PAGES);
}
function misha_my_account_endpoint_content()
{
    echo do_shortcode("[spotplayer_courses]");
}

?>