<?php
namespace Elementor;

class blog4 extends Widget_Base {
	
	public function get_name() {
		return 'blog4';
	}
	
	public function get_title() {
		return 'تمامی مطالب';
	}
	
	
    public function get_icon() {
		return 'eicon eicon-posts-group';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		
		
		$this->add_control(
			'title2',
			[
				'label' => 'تعداد مطالب',
				'label_block' => true,
				'default' => '9',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'یک عدد وارد کنید',
			]
		);
			$this->end_controls_section();


	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		$this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'پس زمینه دیدگاه ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400 .coment' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
				$this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400 .coment' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
	
		   
		   		$this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400-box h3' => 'color: {{VALUE}} !important',
				],
			]
           );
		     		$this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ المان کنار عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400-box h3::before' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	$this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ نام نویسنده ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .itemdet span' => 'color: {{VALUE}} !important',
				],
			]
           );
		      	$this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .itemdet span:last-child' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		       	$this->add_control(
'sepidcolor-9',
			[
				'label' => __( 'رنگ کادر جدا کننده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .itemdet span:last-child' => 'border-right-color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-456456' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					  $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-1400-img img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
						  $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی دیدگاه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-1400 .coment' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						  $this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی موضوع', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-1400 .blog-cat-99' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						  $this->add_responsive_control(
                        'sepidborder-5',
                        [
                            'label' => esc_html__( 'گردی تصویر نویسنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .itemdet span img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
           		$this->end_controls_section();
  
	}
	
	protected function render() {
		
		 $settings = $this->get_settings_for_display();

        $title2 = $settings['title2'];
     
		
		include  'blog.php';
	}
	
	protected function _content_template() {

    }
	
	
}