<?php
namespace Elementor;

class wcategoryfour extends Widget_Base {
	
	public function get_name() {
		return 'wcategoryfour';
	}
	
	public function get_title() {
		return 'دسته بندی 4';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'دسته بندی سپید', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
		
				$this->add_control(
			'title1',
			[
				'label' => esc_html__( 'زیر عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'یک متن دلخواه برای نمایش در دسته بندی', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
		
						$this->add_control(
			'title2',
			[
				'label' => esc_html__( 'تعداد محصولات', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '0', 'plugin-name' ),
				'placeholder' => esc_html__( 'تعداد محصولات دسته بندی', 'plugin-name' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'لینک', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'plugin-name' ),
				'placeholder' => esc_html__( 'لینک دسته بندی را وارد کنید', 'plugin-name' ),
			]
		);
	$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'تصویر دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			
			]
		);
		$this->end_controls_section();
      


  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );


 
		   	   $this->add_control(
                        'titr-124444-44r4rw',
                        [
                            'label' => __( 'پس زمینه تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
		
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background34454r',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .sepid-rtl-cat-one44564564345345',
			]
		);
		
		   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه پس زمینه تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .sepid-rtl-cat-one44564564345345',
			]
		);

				   	   
		
		
		
			   		
		   
		   
		   		   		   	      $this->add_control(
'sepidcolor-755',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-345345erter h5' => 'color: {{VALUE}} !important',
				],
			]
           );
		   		   		   	      $this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ زیر عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-345345erter p' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		      
		   		   		   	      $this->add_control(
'sepidcolor-9',
			[
				'label' => __( 'رنگ شمارنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tedad-dasdt34534' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	   		 		   	      $this->add_control(
'sepidcolor-900',
			[
				'label' => __( 'رنگ متن شمارنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tedad-dasdt34534' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس دسته بندی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sepid-category-two435345' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		   	   		   	        $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sepid-rtl-cat-one44345345' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .sepid-rtl-cat-one44564564345345' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .sepid-category-two3345345345' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
						   	        $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی شمارنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .tedad-dasdt34534' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "
			
			<a href='$settings[link]' target='_blank' class='cat-big1456'> <div class='sepid-category-two435345'>
			";
						echo '

			
			<div class="sepid-rtl-cat-one44345345"><div class="sepid-rtl-cat-one44564564345345"><div class="sepid-category-two3345345345" style="background-image: url(' . $settings['image']['url'] . '); background-size: cover;">
			
			
			</div>	</div></div>
			';
	


	
		echo"
			
			<div class='box-345345erter'>
			<h5>$settings[title] </h5>
			<p>$settings[title1] </p>
			</div>
			
			<div class='tedad-dasdt34534'>$settings[title2]</div>
			
			</div></a>
";
	

	}


	
	protected function _content_template() {

    }
	
	
}