<?php
namespace Elementor;

class wcategorysix extends Widget_Base {
	
	public function get_name() {
		return 'wcategorysix';
	}
	
	public function get_title() {
		return 'دسته بندی ۶';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'دسته بندی سپید', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
		
				$this->add_control(
			'title3',
			[
				'label' => esc_html__( 'کلمه ( آموزش )', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'آموزش', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
		
						$this->add_control(
			'title2',
			[
				'label' => esc_html__( 'تعداد محصولات', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '0', 'plugin-name' ),
				'placeholder' => esc_html__( 'تعداد محصولات دسته بندی', 'plugin-name' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'لینک', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'plugin-name' ),
				'placeholder' => esc_html__( 'لینک دسته بندی را وارد کنید', 'plugin-name' ),
			]
		);
	$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->end_controls_section();
      


  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );


 
		   
		   		   		   	      $this->add_control(
'sepidcolor-75511',
			[
				'label' => __( 'پس زمینه باکس', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .cat-big1456metete' => 'background: {{VALUE}} !important',
				],
			]
           );
				
		
				   	   $this->add_control(
                        'titr-124444-44r4rw',
                        [
                            'label' => __( 'پس زمینه ایکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
		
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background34454r',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .icon-shire-3-erw',
			]
		);
		
		   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه پس زمینه تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .icon-shire-3-erw',
			]
		);

				   	   
		
			   		
		   
		   
		   		   		   	      $this->add_control(
'sepidcolor-755',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .icon-shire-3-erw' => 'color: {{VALUE}} !important',
				],
			]
           );
		   		
		      
		   		   		   	      $this->add_control(
'sepidcolor-9',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-345345ertermetetebt h5' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   		 		   	      $this->add_control(
'sepidcolor-900',
			[
				'label' => __( 'رنگ شمارنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tedad-dasdt34534metetebt' => 'background: {{VALUE}} !important',
				],
			]
           );
		         $this->add_control(
'sepidcolor-9001',
			[
				'label' => __( 'رنگ متن شمارنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tedad-dasdt34534metetebt' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-99',
			[
				'label' => __( 'رنگ عنوان آموزش', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-345345ertermetetebt span' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		
		   
		   	   		   	        $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی دور ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .icon-shire-3-erw' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
						   	        $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی شمارنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .tedad-dasdt34534metetebt' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "
			
			<a href='$settings[link]' target='_blank' class='cat-big1456metetefd1'> <div class='sepid-category-two435345metetefd1'>
			";
						echo '

			
			
			
			';
	

?><div class="icon-shire-3-erw">
			<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
		<?php
	
		echo"
			
			<div class='box-345345ertermetetebt'>
			<h5>$settings[title] </h5>
			
			<div class='tedad-dasdt34534metetebt'>$settings[title2]</div> <span>$settings[title3]</span>
						</div>

			</div></a>
";
	

	}


	
	protected function _content_template() {

    }
	
	
}