<?php
namespace Elementor;

class wcategorythree extends Widget_Base {
	
	public function get_name() {
		return 'wcategorythree';
	}
	
	public function get_title() {
		return 'دسته بندی 3';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'دسته بندی سپید', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
		
				$this->add_control(
			'title1',
			[
				'label' => esc_html__( 'زیر عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '+143 محصول', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
		
						$this->add_control(
			'title2',
			[
				'label' => esc_html__( 'تعداد محصولات', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '0', 'plugin-name' ),
				'placeholder' => esc_html__( 'تعداد محصولات دسته بندی', 'plugin-name' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'لینک', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'plugin-name' ),
				'placeholder' => esc_html__( 'لینک دسته بندی را وارد کنید', 'plugin-name' ),
			]
		);
	$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
	
		$this->end_controls_section();
      


  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );


 
		   	   $this->add_control(
                        'titr-124444-44r4rw',
                        [
                            'label' => __( 'پس زمینه اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
		
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background34454r',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .sepid-category-tfgdfwo',
			]
		);
		
		   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .sepid-category-tfgdfwo',
			]
		);

				   	   $this->add_control(
                        'titr-124444-445r4rw',
                        [
                            'label' => __( 'رنگ پس زمینه آیکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
		
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background344454r',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .icon-shire-3 i',
			]
		);
		
		   	   $this->add_control(
                        'titr-124444-44r45rw88',
                        [
                            'label' => __( 'رنگ سایه آیکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow566',
				'selector' => '{{WRAPPER}} .icon-shire-3 i',
			]
		);
		
		
		
			   		   	      $this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .icon-shire-3 i' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
			   		   	      $this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-category-tfgdfwo h5' => 'color: {{VALUE}} !important',
				],
			]
           );
		   		   		   	      $this->add_control(
'sepidcolor-755',
			[
				'label' => __( 'رنگ زیر عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-category-tfgdfwo p' => 'color: {{VALUE}} !important',
				],
			]
           );
		   		   	
		   
		      
		   		
		   	 
		   
		   	   	   		   	      $this->add_control(
'sepidcolor-11',
			[
				'label' => __( 'رنگ پشت ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .icon-shire-3' => 'background: {{VALUE}} !important',
				],
			]
           );
		   			/* گردی المان ها */
		
			   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس دسته بندی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sepid-category-tfgdfwo' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					  $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .icon-shire-3' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .icon-shire-3 i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "
			
			<a href='$settings[link]' target='_blank' class='cat-big177'> <div class='sepid-category-tfgdfwo'>
			";
						echo '

			
			
			
			
			';
					echo "			
";
?><div class="icon-shire-3">
			<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
		<?php
echo "
		
		";
				?>
	
		<?php
		echo"
			<div class='box-3453458t'>
			<h5>$settings[title] </h5>
			<p>$settings[title1] </p>
			</div></div></a>
";
	

	}


	
	protected function _content_template() {

    }
	
	
}