<?php
namespace Elementor;

class dore extends Widget_Base {
	
	public function get_name() {
		return 'dore';
	}
	
	public function get_title() {
		return 'دروس غیر رایگان';
	}
	
	public function get_icon() {
		return 'eicon-editor-list-ul';
	}
	
	public function get_categories() {
		return [ 'tdars' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
		$this->add_control(
			'code',
			[
				'label' => __( 'کد یکتا درس', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا : course1', 'elementor' ),
			]
		);
		      $this->add_control(
			'zaman99',
			[
				'label' => __( 'نمایش زمان', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	

				$this->add_control(
			'zaman',
			[
				'label' => __( 'زمان درس', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'زمان را وارد کنید', 'elementor' ),
			]
		);
$this->add_control(
			'item_description',
			[
				'label' => __( 'توضیحات خصوصی درس', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'توضیحات درس غیر رایگان', 'plugin-domain' ),
				'placeholder' => __( 'این درس غیر رایگان است', 'plugin-domain' ),
			]
		);
		
				       $this->add_control(
			'donyadl',
			[
				'label' => __( 'نمایش دانلود', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
			$this->add_control(
			'linkdl',
			[
				'label' => __( 'لینک دانلودی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'لینک را وارد کنید', 'elementor' ),
			]
		);
		
		       $this->add_control(
			'donyavideo',
			[
				'label' => __( 'نمایش ویدیو', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	

		$this->add_control(
			'linkvideo',
			[
				'label' => __( 'لینک ویدیو', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'لینک را وارد کنید', 'elementor' ),
			]
		);
			$this->add_control(
			'image',
			[
				'label' => esc_html__( 'تصویر ویدیو', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

$this->add_control(
			'icon',
			[
				'label' => __( 'آیکون درس', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);


		$this->end_controls_section();
		
		
  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

	$this->add_control(
			'title_color2',
			[
				'label' => __( 'رنگ پس زمینه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .course-panel-heading-4.accordion' => 'background: {{VALUE}} !important',
				],
			]
		);
	$this->add_control(
			'title_color3',
			[
				'label' => __( 'رنگ کادر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .course-panel-heading-4.accordion' => 'border-color: {{VALUE}} !important',
				],
			]
		);
		
		
		
			$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .onvan45654645' => 'color: {{VALUE}} !important',
				],
			]
		);
		
			$this->add_control(
			'title_color1',
			[
				'label' => __( 'رنگ متن دسترسی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .private-lesson1' => 'color: {{VALUE}} !important',
				],
			]
		);
		
			$this->add_control(
			'title_color4',
			[
				'label' => __( 'رنگ پس زمینه ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .course-lesson-icon' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'title_color5',
			[
				'label' => __( 'رنگ آیکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .course-lesson-icon' => 'color: {{VALUE}} !important',
				],
			]
		);
		
			$this->add_control(
			'title_color6',
			[
				'label' => __( 'رنگ پس زمینه زمان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .zaman' => 'background: {{VALUE}} !important',
				],
			]
		);
			$this->add_control(
			'title_color7',
			[
				'label' => __( 'رنگ متن زمان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .zaman' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		
			   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .course-panel-heading-4.accordion' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
			   $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی زمان', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .zaman' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						   $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی دور ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .course-lesson-icon' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
				$this->end_controls_section();

	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

		?>
		
		<?php


// print_r($atts);
// Get current user and check if he bought current course
$bought_course = false;
$current_user = wp_get_current_user();
if( !empty($current_user->user_email) and !empty($current_user->ID) ) {
	if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, get_the_id() ) ) {
		$bought_course = true;
	}
	
}
global $product;
$current_user = wp_get_current_user();
?>

<div class="course-panel-heading-4 accordion">

<div class="course-panel-heading accordions<?php echo '' . $settings['title'] . ''; ?><?php echo '' . $settings['code'] . ''; ?>">
    <div class="panel-heading-left">
            <div class="course-lesson-icon">
		
			<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </div>
        



				<?php

		 echo "

		 
		     <div class='title'>
                <h4><span class='onvan45654645'>$settings[title]</span>
                
";
			
			 ?>
			          								<?php if ( 'yes' === $settings['zaman99'] ) { ?>

			<?php
echo "<span class='zaman'><i class='fi fi-rr-clock'></i> $settings[zaman]</span>
              ";

	 ?>
			          									<?php } ?>
  </h4>
            </div>
			<?php
		 ?>
		
		 
		     </div>
        <div class="panel-heading-right">
         
			           <div class="divboxi"></div>

                <div class="private-lesson">								<?php if ( 'yes' === $settings['donyadl'] ) { ?>

			
		
		

				<?php
							if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->id)) {
								echo '				<a class="download-shod-nashod" target="_blank" href="' . $settings['linkdl'] . '"><i class="fi fi-rr-download"></i></a>
';
								}
							else {
								echo '				<a class="download-shod-nashod lockshod"><i class="fi fi-rr-download"></i></a>
';
							}
				?>
				
					<?php } ?>
					<span>
					
						
				                <div class="private-lesson1">

				<?php
							if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->id)) {
								echo '<i class="fa fa-unlock"></i>';
								}
							else {
								echo '<i class="fa fa-lock"></i>';
							}
				?>
					<span>
						<?php
							if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->id)) {
								esc_html_e('در دسترس', 'yadgiri');
								}
							else {
								esc_html_e('خصوصی', 'yadgiri');
							}

						?>
					</span></div></div>
        </div>

</div>

    <div class="panel-content panel">
        <div class="panel-content-inner">
   <div class="private-lesson-content">
						<?php if ( 'yes' === $settings['donyavideo'] ) { ?>
							
							<?php
							if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->id)) {
					
								
								
								?>
								
										<div class="video-donya-course">
							<video controls="" poster="<?php echo '' . $settings['image']['url'] . '' ?>">
                        <source src="<?php echo '' . $settings['linkvideo'] . ''; ?>" type="video/mp4">
                    </video>
							</div>
							
								<?php
								
							}
							else {
echo ""
;
							}

						?>
						
							
							<?php } ?>
					<span>
						<?php
							if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->id)) {
echo "$settings[item_description]";
								}
							else {
echo "برای مشاهده این درس باید دوره را خریداری کنید"
;
							}

						?>
					</span></div>
        </div>
    </div> </div>
	<script>
	var acc = document.getElementsByClassName("accordions<?php echo '' . $settings['title'] . ''; ?><?php echo '' . $settings['code'] . ''; ?>");
var i;

for (i = 0; i < acc.length; i++) {
  acc[i].addEventListener("click", function() {
    /* Toggle between adding and removing the "active" class,
    to highlight the button that controls the panel */
    this.classList.toggle("active");

    /* Toggle between hiding and showing the active panel */
    var panel = this.nextElementSibling;
    if (panel.style.display === "block") {
      panel.style.display = "none";
    } else {
      panel.style.display = "block";
    }
  });
} 
</script>
	<?php

	}
	
	protected function _content_template() {

    }
	
	
}