<?php
namespace Elementor;

class download extends Widget_Base {
	
	public function get_name() {
		return 'download';
	}
	
	public function get_title() {
		return 'فایل دانلودی رایگان';
	}
	
	public function get_icon() {
		return 'eicon-download-circle-o';
	}
	
	public function get_categories() {
		return [ 'tdars' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
			$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
	$this->add_control(
			'title1',
			[
				'label' => __( 'حجم فایل', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا 53MB', 'elementor' ),
			]
		);
				$this->add_control(
			'link',
			[
				'label' => __( 'لینک دانلود', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'لینک فایل دانلودی را وارد کنید', 'elementor' ),
			]
		);


		$this->end_controls_section();
		
		
				  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
            		   	             $this->add_control(

	
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-download-product23' => 'background: {{VALUE}} !important',
				],
			]
           );
		   	   	             $this->add_control(
'sepidcolor-255',
			[
				'label' => __( 'رنگ پس زمینه حجم', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634rrrr' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	             $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ حجم', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634rrrr' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   
			
		   	             $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ متن رایگان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634.hfgddreerety5' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   	             $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ پس زمینه دانلود', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634dl.fgtr4' => 'background: {{VALUE}} ',
				],
			]
           );
		   	             $this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ متن دانلود', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634dl.fgtr4' => 'color: {{VALUE}} ',
				],
			]
           );
		   
		   
		   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .box-download-product23',
			]
		);
		 $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-download-product23' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی حجم', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .raygan35634rrrr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						 $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی دانلود', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .raygan35634dl' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								$this->end_controls_section();
								
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
			echo "
			<div class='box-download-product'>
						<div class='box-download-product23'>
	
	<div class='title-54321'> $settings[title]    <span class='raygan35634rrrr'>
$settings[title1]  </span>

</div>


<div class='khosoosi'> <a href='$settings[link]' blank='_target' class='raygan35634dl fgtr4'><i class='mdi mdi-download'></i> دانلود </a>

<span class='raygan35634 hfgddreerety5'>رایگان </span>

</div>

			</div>
			</div>
			
			
			";
		 

	}
	
	protected function _content_template() {

    }
	
	
}