<?php
namespace Elementor;

class downloads extends Widget_Base {
	
	public function get_name() {
		return 'downloads';
	}
	
	public function get_title() {
		return 'فایل دانلودی';
	}
	
	public function get_icon() {
		return 'eicon-download-circle-o';
	}
	
	public function get_categories() {
		return [ 'tdars' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
	$this->add_control(
			'title1',
			[
				'label' => __( 'حجم فایل', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا 53MB', 'elementor' ),
			]
		);
				$this->add_control(
			'link',
			[
				'label' => __( 'لینک دانلود', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'لینک فایل دانلودی را وارد کنید', 'elementor' ),
			]
		);

		$this->end_controls_section();
		
		  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
            
		   	             $this->add_control(

'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-download-product23' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   	             $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ پس زمینه حجم', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634rrrr' => 'background: {{VALUE}} !important',
				],
			]
           );
		   	             $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ حجم', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634rrrr' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
			
		   	             $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ متن دسترسی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   	             $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ پس زمینه دانلود', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634dl' => 'background: {{VALUE}} ',
				],
			]
           );
		   	             $this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ متن دانلود', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .raygan35634dl' => 'color: {{VALUE}} ',
				],
			]
           );
		   
		   
		   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .box-download-product23',
			]
		);
				 $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-download-product23' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی حجم', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .raygan35634rrrr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						 $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی دانلود', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .raygan35634dl' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								$this->end_controls_section();

	}
	
	
	


	protected function render() {

        $settings = $this->get_settings_for_display();

		?>
		
		<?php


// print_r($atts);
// Get current user and check if he bought current course
$bought_course = false;
$current_user = wp_get_current_user();
if( !empty($current_user->user_email) and !empty($current_user->ID) ) {
	if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, get_the_id() ) ) {
		$bought_course = true;
	}
}
global $product;
$current_user = wp_get_current_user();
?>

			<div class='box-download-product'>
						<div class='box-download-product23'>
				
        



				<?php

		 echo "

		 
	
	<div class='title-54321'> $settings[title]    <span class='raygan35634rrrr'>
$settings[title1]  </span>

</div>




		
			";
		 ?>
		<div class='khosoosi'>
		
				<?php
							if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->id)) {
echo " <a href='$settings[link]' blank='_target'  class='raygan35634dl fgtr4'><i class='mdi mdi-download'></i> دانلود </a>
";
								}
							else {
echo "<a class='raygan35634dl nofree'><i class='mdi mdi-download'></i> دانلود </a>"
;
							}

						?>
						
  <span class='raygan35634'>
				<?php
							if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->id)) {
								echo '<i class="fa fa-unlock"></i>';
								}
							else {
								echo '<i class="fa fa-lock"></i>';
							}
				?>
						<?php
							if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->id)) {
								esc_html_e('در دسترس', 'donya');
								}
							else {
								esc_html_e('خصوصی', 'donya');
							}

						?>
			</span>

</div>
			</div>
	</div>

	<?php

	}
	
	protected function _content_template() {

    }
	
	
}