<?php
namespace Elementor;

class modares extends Widget_Base {
	
	public function get_name() {
		return 'modares';
	}
	
	public function get_title() {
		return 'مدرس دوره';
	}
	
	public function get_icon() {
		return 'eicon-user-circle-o';
	}
	
	public function get_categories() {
		return [ 'tdars' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'نام مدرس', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'نامی وارد کنید', 'elementor' ),
			]
		);
		
			$this->add_control(
			'title1',
			[
				'label' => __( 'تخصص مدرس', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'تخصص را وارد کنید', 'elementor' ),
			]
		);
			$this->add_control(
			'title2',
			[
				'label' => __( 'درباره مدرس', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'متنی بنویسید', 'elementor' ),
			]
		);
				$this->add_control(
			'title3',
			[
				'label' => __( 'سطح مدرس', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا : حرفه ای', 'elementor' ),
			]
		);
		
				$this->add_control(
			'title4',
			[
				'label' => __( 'لینک درباره مدرس', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'لینکی وارد کنید', 'elementor' ),
			]
		);
				$this->add_control(
			'image',
			[
				'label' => __( 'تصویر مدرس', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
			
		$this->end_controls_section();
		
		 $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
				$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ نام', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .mpdares-onvan-boc1' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color1',
			[
				'label' => __( 'رنگ پس زمینه تخصص', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .mpdares-onvan-boc1 span' => 'background: {{VALUE}}',
				],
			]
		);
			$this->add_control(
			'title_color2',
			[
				'label' => __( 'رنگ متن تخصص', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .mpdares-onvan-boc1 span' => 'color: {{VALUE}}',
				],
			]
		);
		
			$this->add_control(
			'title_color3',
			[
				'label' => __( 'رنگ متن', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .mpdares-onvan-boc2' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'title_color4',
			[
				'label' => __( 'رنگ متن سطح مدرس', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .onvan-mod-1' => 'color: {{VALUE}}',
				],
			]
		);
		
		
			$this->add_control(
			'title_color5',
			[
				'label' => __( 'رنگ پس زمینه دکمه بیشتر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .onvan-modares-link' => 'background: {{VALUE}}',
				],
			]
		);
		
			$this->add_control(
			'title_color6',
			[
				'label' => __( 'رنگ متن دکمه بیشتر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .onvan-modares-link' => 'color: {{VALUE}}',
				],
			]
		);
		
		
		
		 $this->add_control(
                        'titr-124444-44r4rw',
                        [
                            'label' => __( 'پس زمینه تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
		
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background34454r',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .modares-img-border',
			]
		);
		
		   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .modares-img-border',
			]
		);
		
		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .modares-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		  $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .modares-img-border' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .modares-img-border-2' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .modares-img-border-2 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						   $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی تخصص', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mpdares-onvan-boc1 span' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						   $this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی دکمه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .onvan-modares-link' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		echo "
<div class='modares-1'>
<div class='modares-2'>
<div class='modares-2-left'>
<div class='modares-img-border'>
<div class='modares-img-border-2'>
";
echo ' <img src="' . $settings['image']['url'] . '">
';
echo "

</div>


</div>

<div class='mpdares-onvan-boc'>
<div class='mpdares-onvan-boc1'>
$settings[title] <span>$settings[title1] </span>
</div>
<div class='mpdares-onvan-boc2'>
$settings[title2]
</div>
</div>
</div>
<div class='modares-2-right'>

<div class='onvan-mod-1'>
این مدرس $settings[title3] است
</div>

<div class='onvan-mod-2'>
<a href='$settings[title4]' target='_blank' class='onvan-modares-link'>
درباره مدرس دوره بیشتر بدانید
</a>
</div>



</div>

</div>

</div>
";

			

	}


	
	protected function _content_template() {

    }
	
	
}