<?php
namespace Elementor;

class dore2 extends Widget_Base {
	
	public function get_name() {
		return 'dore2';
	}
	
	public function get_title() {
		return 'عنوان سر فصل';
	}
	
	public function get_icon() {
		return 'eicon-site-title';
	}
	
	public function get_categories() {
		return [ 'tdars' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان سر فصل', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
	$this->add_control(
			'title1',
			[
				'label' => __( 'زمان کل سرفصل', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا 198 دقیقه', 'elementor' ),
			]
		);

		$this->end_controls_section();



  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

	
			$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .dore-title-2' => 'color: {{VALUE}}',
				],
			]
		);
			$this->add_control(
			'title_color1',
			[
				'label' => __( 'رنگ پس زمینه زمان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .time-dore-1' => 'background: {{VALUE}}',
				],
			]
		);
		
				$this->add_control(
			'title_color2',
			[
				'label' => __( 'رنگ متن زمان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .time-dore-1' => 'color: {{VALUE}}',
				],
			]
		);
		
		  $this->add_control(
                        'titr-124444-44r4rw',
                        [
                            'label' => __( 'پس زمینه المان کناری', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
		
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background34454r',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .dore-title-1::before',
			]
		);
		
		   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه المان کناری', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .dore-title-1::before',
			]
		);
		
		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی دور زمان', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .time-dore-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		echo  "
<div class='dore-title-1' id='list'>
<div class='dore-title-2'>
$settings[title] 
</div>
<div class='time-dore-1'>
$settings[title1] </div>

</div>

";

			

	}


	
	protected function _content_template() {

    }
	
	
}