<?php
namespace Elementor;

class amar extends Widget_Base {
	
	public function get_name() {
		return 'amar';
	}
	
	public function get_title() {
		return 'آمار';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'امار', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '24 دانشجو', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
		$this->add_control(
			'title1',
			[
				'label' => esc_html__( 'متن زیر امار', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'دارای مدرک تحصیلی', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
	
	$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->end_controls_section();
      


  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

		
		   $this->add_control(
                        'titr-12-3w4',
                        [
                            'label' => __( 'رنگ پس زمینه ایکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
	
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background4',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .amar-icon-32-icon',
			]
		);
				   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه ایکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .amar-icon-32-icon',
			]
		);	

		   	    $this->add_control(
'sepidcolor-243',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .amar-icon-32-icon' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .amar-box-two-2' => 'color: {{VALUE}} !important',
				],
			]
           );
		   	    $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ متن زیر امار', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .amar-box-two-3' => 'color: {{VALUE}} !important',
				],
			]
           );
		
		    		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی دور ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .amar-icon-32-icon' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
			
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();



?><div class="amar-icon-32">
		<div class="amar-icon-32-icon">	<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
			
			</div>
			
			<div class="amar-box-two-1">
			<div class="amar-box-two-2">
			<?php echo '' . $settings['title'] . ''; ?>
			</div>
			<div class="amar-box-two-3">
<?php echo '' . $settings['title1'] . ''; ?>			</div>
			</div>
			
			
			</div>
		<?php
	
		
		

	}


	
	protected function _content_template() {

    }
	
	
}