<?php
namespace Elementor;

class headmenu extends Widget_Base {
	
	public function get_name() {
		return 'headmenu';
	}
	
	public function get_title() {
		return 'منو سربرگ';
	}
	
    public function get_icon() {
		return 'eicon eicon-nav-menu';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک عنوان وارد کنید', 'elementor' ),
			]
		);
 $this->add_control(
			'color-sepid-12',
			[
				'label' => esc_html__( 'رنگ متن منو اصلی', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .menu-header.sepid-menu-asli ul li a' => 'color: {{VALUE}}',
				],
			]
		);	
	
	$this->add_control(
'menu-size',
			[
				'label' => __( 'حداقل ارتفاع منو تب', 'plugin-domain' ),
				'type' => Controls_Manager::TEXT,
								'placeholder' => __( '470', 'elementor' ),
				'selectors' => [
					'{{WRAPPER}} .menu-header.sepid-menu-asli .dmega .sub-menu' => 'min-height: {{VALUE}}px ',
					'{{WRAPPER}} .menu-header.sepid-menu-asli .dmega .sub-menu li .sub-menu' => 'min-height: {{VALUE}}px ',
				
				],
			]
		);
		
   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس منو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .menu-header.sepid-menu-asli .dmega .sub-menu' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .menu-header.sepid-menu-asli .mega .sub-menu' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .menu-header.sepid-menu-asli ul li .sub-menu' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .menu-header.sepid-menu-asli .dmega .sub-menu li .sub-menu' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					   $this->add_responsive_control(

					                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی منو اصلی در منو تب', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .menu-header.sepid-menu-asli .dmega .sub-menu li a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
					
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		

		?>



<script>

jQuery(document).ready(function($){
    $('.dmega li').hover(
         function(){ $(this).prev().addClass('dmega-radius') },
         function(){ $(this).prev().removeClass('dmega-radius') }
    )
});
jQuery(document).ready(function($){
    $('.dmega').hover(
         function(){ $(this).addClass('test-grey') },
         function(){ $(this).removeClass('test-grey') }
    )
});

</script>

<div class="menu-header sepid-menu-asli">
<?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?> 

</div>
	<?php
	

	}
	
	protected function _content_template() {

    }
	
	
}