<?php
namespace Elementor;

class postgrid1 extends Widget_Base {
	
	public function get_name() {
		return 'postgrid1';
	}
	
	public function get_title() {
		return 'مطالب 6';
	}
	
	public function get_icon() {
		return 'eicon-posts-grid';
	}
	
	public function get_categories() {
		return [ 'donya' ];
	}
	
	protected function register_controls() {
		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);
		$this->end_controls_section();

              $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
       $this->add_control(
			'show1',
			[
				'label' => __( 'نمایش دیدگاه', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		      
		
		
		
			       $this->add_control(
			'show2',
			[
				'label' => __( 'نمایش تاریخ', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
			      
		
		$this->end_controls_section();
		
		
		
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		
			$this->add_control(
'sepidcolor-144ق',
			[
				'label' => __( 'پس زمینه اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-er34r34r' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		$this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'پس زمینه دیدگاه ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .coment56tt56' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
				$this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .coment56tt56' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		
		     	
		   		$this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-er34r34r h3' => 'color: {{VALUE}} !important',
				],
			]
           );
	
		      	$this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ پس زمینه تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .taikhrrrrr' => 'background: {{VALUE}} !important',
				],
			]
           );
		        	$this->add_control(
'sepidcolor-458',
			[
				'label' => __( 'رنگ متن تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .taikhrrrrr' => 'color: {{VALUE}} !important',
				],
			]
           );

		   	   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-img-er34r34r' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				
						  $this->add_responsive_control(
                        'sepidborder-5564',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-img-er34r34r img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						  $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی دیدگاه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .coment56tt56' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				
					
						  $this->add_responsive_control(
                        'sepidborder-5',
                        [
                            'label' => esc_html__( 'گردی تاریخ', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .taikhrrrrr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
           		$this->end_controls_section();
  

	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>
 

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="box-img-ghjj5rgr99">
	

<div class="box-img-er34r34r">
<div class="sdfge5t4fimg"><a href="<?php the_permalink(); ?>">
	<?php the_post_thumbnail(''); ?>
	</a>
	<div class="aefwerwefweimgg">
	
			 <?php if ( 'yes' === $settings['show1'] ) { ?>
<div class="coment56tt56"><i class="mdi mdi-comment-outline"></i><span><?php comments_number( '0', ' 1 ', ' % ' ); ?></span></div><?php } ?>
											 <?php if ( 'yes' === $settings['show2'] ) { ?>
<span class="taikhrrrrr"><i class="mdi mdi-timer"></i><?php the_time('d M Y'); ?></span>	<?php } ?>
</div>
</div>
<a href="<?php the_permalink(); ?>">

	<div class="bix-postr-adrr">
	<h3><?php the_title(); ?></h3>
								
	
	</div></a>
</div>
</div>
			<?php endwhile; ?>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div>
   		</div>
        <?php

	}

}