<?php
namespace Elementor;

class postgrid extends Widget_Base {
	
	public function get_name() {
		return 'postgrid';
	}
	
	public function get_title() {
		return 'مطالب 3';
	}
	
	public function get_icon() {
		return 'eicon-posts-grid';
	}
	
	public function get_categories() {
		return [ 'donya' ];
	}
	
	protected function register_controls() {
		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);
		$this->end_controls_section();

              $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
       $this->add_control(
			'show1',
			[
				'label' => __( 'نمایش دیدگاه', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		      
		
		
		
			       $this->add_control(
			'show2',
			[
				'label' => __( 'نمایش تاریخ', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
			      
		
		$this->end_controls_section();
		
		
		
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		$this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'پس زمینه دیدگاه ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .coment5656' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
				$this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .coment5656' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   		$this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'پس زمینه دیدگاه نوع دوم', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt .coment5656' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt .coment5656' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		     		$this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ ایکون دیدگاه نوع دوم', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt .coment5656' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt .coment5656' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   		$this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bix-postr-ad h3' => 'color: {{VALUE}} !important',
				],
			]
           );
		     		$this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ عنوان نوع دوم', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	$this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ پس زمینه ایکون تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt .taikhrr i' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt .taikhrr i' => 'background: {{VALUE}} !important',
				],
			]
           );
		      	$this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ ایکون تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt .taikhrr i' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt .taikhrr i' => 'color: {{VALUE}} !important',
				],
			]
           );
		        	$this->add_control(
'sepidcolor-458',
			[
				'label' => __( 'رنگ متن تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt .taikhrr' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt .taikhrr' => 'color: {{VALUE}} !important',
				],
			]
           );
		       	$this->add_control(
'sepidcolor-9',
			[
				'label' => __( 'رنگ پس زمینه کادر داخلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-img-wer555f34r' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				
					
					
						  $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی دیدگاه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .coment5656' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						  $this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt .taikhrr i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt .taikhrr i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						  $this->add_responsive_control(
                        'sepidborder-5',
                        [
                            'label' => esc_html__( 'گردی باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-img-werf34r:nth-child(4) .bix-postr-adt' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .box-img-werf34r:nth-child(5) .bix-postr-adt' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
           		$this->end_controls_section();
  

	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			  <div class="">
			<?php if ( $postsquery->have_posts() ) { ?>
 

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="box-img-werf34r">
	<a href="<?php the_permalink(); ?>">

<div class="box-img-wer555f34r">

	<?php the_post_thumbnail(''); ?>

	<div class="bix-postr-ad">
	<div class="bix-postr-adt">
	<h3><?php the_title(); ?></h3>
										 <?php if ( 'yes' === $settings['show1'] ) { ?>
<div class="coment5656"><i class="mdi mdi-comment-outline"></i><span><?php comments_number( '0', ' 1 ', ' % ' ); ?></span></div><?php } ?>
											 <?php if ( 'yes' === $settings['show2'] ) { ?>
<span class="taikhrr"><i class="mdi mdi-timer"></i><?php the_time('d M Y'); ?></span>	<?php } ?>
	</div>
	</div>
</div></a>
</div>
			<?php endwhile; ?>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div></div>
   		</div>
        <?php

	}

}