<?php
namespace Elementor;

class postfive extends Widget_Base {
	
	public function get_name() {
		return 'postfive';
	}
	
	public function get_title() {
		return 'مطالب 5';
	}
	
	public function get_icon() {
		return 'eicon-posts-grid';
	}
	
	public function get_categories() {
		return [ 'donya' ];
	}
	
	protected function register_controls() {
		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);
		  
    				       $this->add_control(
			'farnamoneshow7',
			[
				'label' => __( 'تکرار شوندگی در اسلایدر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->end_controls_section();


		
         $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش نویسنده', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش تاریخ', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش تعداد دیدگاه', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
     
       $this->add_control(
			'farnamoneshow4',
			[
				'label' => __( 'نمایش باکس زیر مطالب', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
  
        $this->end_controls_section();



	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		
			$this->add_control(
'sepidcolor-1755',
			[
				'label' => __( 'پس زمینه اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-140067867motete-post32' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		$this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'پس زمینه داخلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-140067867motete-post321' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .user-meta-0box-13 svg path' => 'fill: {{VALUE}} !important',
				],
			]
           );
		   $this->add_control(
                        'titr-124444-44r45rwtrt1',
                        [
                            'label' => __( 'سایه باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shttafdow1',
				'selector' => '{{WRAPPER}} .bloglist-140067867motete-post321',
			]
		);
				
		   
		   		$this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ پس زمینه تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .user-meta-0box-13 img' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		 
		   
		   		$this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-140067867motete-post321 h4' => 'color: {{VALUE}} !important',
				],
			]
           );
		     		
		   		$this->add_control(
'sepidcolor-554',
			[
				'label' => __( 'رنگ پس زمینه ایکون تاریخ انتشار', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .date-22230 i' => 'background: {{VALUE}} !important',
				],
			]
           );
		     		
		  		$this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ ایکون تاریخ انتشار', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .date-22230 i' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   		$this->add_control(
'sepidcolor-6666',
			[
				'label' => __( 'رنگ متن تاریخ انتشار', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .date-22230' => 'color: {{VALUE}} !important',
				],
			]
           );
		    		$this->add_control(
'sepidcolor-6666',
			[
				'label' => __( 'رنگ پس زمینه تعداد دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .coment-ttret5.nik865' => 'background: {{VALUE}} !important',
				],
			]
           );
		     			$this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ متن تعداد دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .coment-ttret5' => 'color: {{VALUE}} !important',
				],
			]
           );	
		 
		   
					$this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-slidetworrpostfour1.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
           );	
		 
		   			$this->add_control(
'sepidcolor-548',
			[
				'label' => __( 'رنگ متن دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-slidetworrpostfour1.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           );	
		 
		   	   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-140067867motete-post32' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					  $this->add_responsive_control(
                        'sepidborder-134432',
                        [
                            'label' => esc_html__( 'گردی باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-140067867motete-post321' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					  $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-140067867motete-post32img img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
						  $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی تصویر نویسنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .user-meta-0box-13 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				
					
						  $this->add_responsive_control(
                        'sepidborder-5',
                        [
                            'label' => esc_html__( 'گردی ایکون تاریخ', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .date-22230 i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					 $this->add_responsive_control(
                        'sepidborder-5frrt',
                        [
                            'label' => esc_html__( 'گردی تعداد دیدگاه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .coment-ttret5' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					  $this->add_responsive_control(
                        'sepidborder-6',
                        [
                            'label' => esc_html__( 'گردی دور دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .owl-slidetworrpostfour1.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
           		$this->end_controls_section();
  

	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99 dfgdgtre4te5t">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			  <div class="">
			<?php if ( $postsquery->have_posts() ) { ?>
 
			<script>
			   $(document).ready(function(){
$('.owl-slidetworrpostfour1').owlCarousel({
  <?php if ( 'yes' === $settings['farnamoneshow7'] ) { ?>
  loop:true,<?php } ?>
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:0,
    dots: false,

    responsive:{
        0:{
            items:1
        },
		  600:{
            items:1
        },
        900:{
            items:3
        },
        1200:{
            items:4
        }
    }
})
});
</script>
     		                   <div class="owl-slidetworrpostfour1 owl-carousel bxboxone">

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="bloglist-140067867motete-post">
<div class="bloglist-140067867motete-post32"><a href="<?php the_permalink(); ?>">

<div class="bloglist-140067867motete-post321">
<div class="bloglist-140067867motete-post32img">
<?php the_post_thumbnail(''); ?>

</div>							<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

<div class="user-meta-0box-13">
<svg xmlns="http://www.w3.org/2000/svg" width="231" height="75" viewBox="0 0 231 75" fill="none" style="float: right;margin-bottom: -100px;position: relative;z-index: 9;margin-top: 20px;margin-right: 30px;transform: rotate( 180deg );float: unset;margin: auto;margin-top: -100px;margin-bottom: 33px;margin-right: 30px;">
                        <path clip-rule="evenodd" d="M0 0C31.5006 0.949537 50.52 17.872 56.1955 26.4544L55.986 25.8011L82.4924 58.631C99.3032 79.4521 131.038 79.4521 147.849 58.6309L174.356 25.8011L174.146 26.4544C179.822 17.872 198.844 0.949537 230.349 0H0Z" fill="#FCFCFC" fill-rule="" style="fill: #fff;"></path>
                    </svg>
	      <?php
if (function_exists('get_avatar')) {
echo get_avatar( get_the_author_meta('email'), '100' );
}
?><div class="user-meta-0box-131">

<?php echo get_the_author_meta('display_name'); ?>
</div>
</div><?php } ?>
<h4><?php the_title(); ?></h4>


</div><?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?>
</a>
<div class="bloglist-140067867motete-post3213"><?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
<div class="date-22230"><i class="mdi mdi-timer"></i>
<?php the_time('d M Y'); ?>
</div><?php } ?>
<?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>
<div class="coment-ttret5 nik865"><i class="mdi mdi-comment-outline"></i><span><?php comments_number( '0', ' 1 ', ' % ' ); ?></span></div>	<?php } ?>
</div><?php } ?>
</div>
		</div>
			<?php endwhile; ?>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div></div></div>
   		</div>
        <?php

	}

}