<?php
namespace Elementor;

class posttwo extends Widget_Base {
	
	public function get_name() {
		return 'posttwo';
	}
	
	public function get_title() {
		return 'مطالب 2';
	}
	
	public function get_icon() {
		return 'eicon-posts-grid';
	}
	
	public function get_categories() {
		return [ 'donya' ];
	}
	
	protected function register_controls() {
		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);
		  
    				       $this->add_control(
			'farnamoneshow7',
			[
				'label' => __( 'تکرار شوندگی در اسلایدر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->end_controls_section();


		
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
		$this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'پس زمینه دیدگاه ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400 .coment' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
				$this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن دیدگاه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400 .coment' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   		$this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ پس زمینه موضوع', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400 .blog-cat-99' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		     		$this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ متن موضوع', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400 .blog-cat-99' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   		$this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400-box h3' => 'color: {{VALUE}} !important',
				],
			]
           );
		     		$this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ المان کنار عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bloglist-1400-box h3::before' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	$this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ نام نویسنده ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .itemdet span' => 'color: {{VALUE}} !important',
				],
			]
           );
		      	$this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .itemdet span:last-child' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		       	$this->add_control(
'sepidcolor-9',
			[
				'label' => __( 'رنگ کادر جدا کننده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .itemdet span:last-child' => 'border-right-color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-456456' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					  $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-1400-img img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
						  $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی دیدگاه', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-1400 .coment' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						  $this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی موضوع', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .bloglist-1400 .blog-cat-99' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						  $this->add_responsive_control(
                        'sepidborder-5',
                        [
                            'label' => esc_html__( 'گردی تصویر نویسنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .itemdet span img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
           		$this->end_controls_section();
  

	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99 dfgdgtr">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			  <div class="">
			<?php if ( $postsquery->have_posts() ) { ?>
 
			<script>
			   $(document).ready(function(){
$('.owl-slidetworrpost').owlCarousel({
  <?php if ( 'yes' === $settings['farnamoneshow7'] ) { ?>
  loop:true,<?php } ?>
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:0,
    dots: false,

    responsive:{
        0:{
            items:1
        },
		  600:{
            items:1
        },
        900:{
            items:3
        },
        1200:{
            items:4
        }
    }
})
});
</script>
     		                   <div class="owl-slidetworrpost owl-carousel bxboxone">

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="bloglist-140067867">
<a class="blog-45645667876" href="<?php the_permalink(); ?>">
<div class="bloglist-1400-678img">
	<?php the_post_thumbnail(''); ?>
</div>
<div class="bloglist-1400-bo67867x">

<h3><?php the_title(); ?></h3>
										


<div class="itemdet555">
<div class="come76867nt"><i class="mdi mdi-comment-outline"></i><span><?php comments_number( '0', ' 1 ', ' % ' ); ?></span></div>	

<span><?php the_time('d M Y'); ?></span>									
</div>
</div>
</a>

</div>
			<?php endwhile; ?>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div></div></div>
   		</div>
        <?php

	}

}