<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class lpish extends Widget_Base {

    public function get_name() {
        return 'lpish';
    }
    
    public function get_title() {
        return __( 'پیشنهاد لحظه ای', 'woolentor' );
    }


      public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
												 'show_byid'     => esc_html__( 'انتخاب محصول', 'woolentor' ),

                    ],
                ]
            );
             $this->add_control(
                'woolentor_product_id',
                [
                    'label'         => __( 'چند محصول انتخاب کنید', 'woolentor' ),
                    'type'          => Controls_Manager::SELECT2,
                    'label_block'   => true,
                    'multiple'      => true,
                    'options'       => Wootar_post_name( 'product' ),
                    'condition'     => [
                        'woolentor_product_grid_product_filter' => 'show_byid',
                    ]
                ]
            );

                   $this->add_control(
                'woolentor_product_ids_manually',
                [
                    'label'         => __( 'Product IDs', 'woolentor' ),
                    'type'          => Controls_Manager::TEXT,
                    'label_block'   => true,
                    'condition'     => [
                        'woolentor_product_grid_product_filter' => 'show_byid_manually',
                    ]
                ]
            );
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => Wootar_woocommerce_product_categories(),
                ]
            );
           

          

        $this->end_controls_section();

       

        

  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             
$this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ عنوان اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .moment-offer33 h2' => 'color: {{VALUE}} !important',
				],
			]
           );
$this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ عنوان محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .moment-offer33 h2' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daroffer-sepid.mizan-sepid .offer-asli' => 'background: {{VALUE}} !important',
				],
			]
           );
        		   $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daroffer-sepid.mizan-sepid .offer-asli' => 'color: {{VALUE}} !important',
				],
			]
           );
          $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta-price-98' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .risk-meta-price-98 ins' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		             $this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .risk-meta-price-98 del' => 'color: {{VALUE}} !important',
				],
			]
           );
		   	             $this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ لود کننده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .slide-progress' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   		    $this->add_control(
                        'titr-12-3w4',
                        [
                            'label' => __( 'رنگ پس زمینه دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
					$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background1',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .iranboximd',
			]
		);
		
		   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'رنگ سایه دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .iranboximd',
			]
		);
		     $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .moment-offer' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   	     $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی باکس داخلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .moment-offer33' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					    $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .iranboximd' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .biowefwf34' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .biowefwf34 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						     $this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .daroffer-sepid.mizan-sepid .offer-asli' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
	            $this->end_controls_section();



             

          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
    
        ];

        $slider_responsive_settings = [
           

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;
 case 'show_byid':
                $args['post__in'] = $settings['woolentor_product_id'];
            break;
            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-listslide566cv';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-listslide566cv';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-listslide566cv';
                }
            }
        }

        ?>
              
			
			           <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                $tabcatargs = array(
                    'orderby'    => 'name',
                    'order'      => 'ASC',
                    'hide_empty' => true,
                    'slug'       => $product_cats,
                );
                $tabcat_fach = get_terms( 'product_cat', $tabcatargs );
                foreach( $tabcat_fach as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    if( 'featured' == $product_type ){
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'featured',
                            'operator' => 'IN',
                        );
                    }
                    $products = new \WP_Query( $args );

                    if( $products->have_posts() ):
                    ?>
					
 
                <?php endif; endforeach;?>

            <?php else:?>
        <div class="ps2 product-style htpp sepid-111-2313555">
					
                 <div class="moment-offer">  <div class="moment-offer33">
		<div class="gerdali43">
				 				 <div class="gerdali43ox" style="background: #ff4f4f;">
</div> 
				  <div class="gerdali43ox" style="background: orange;">
</div> 
				  <div class="gerdali43ox">
</div> 
				 
				 </div>
				 <h2> 		پیشنهاد لحظه ای </h2>
<div class="loader-bar-2">
</div>



<style>

.owl-demo .item img {
  display: block;
  width: 100%;
  height: auto;
}
.slide-progress {
	width: 0;
	max-width: 100%;
	height: 2px;
	background: #dbceff;
	border-radius: 90px;
}
</style><div class="moment-one">

<div class="owl-demo">
    <div class="slide-progress-two"></div>

    <div class="slide-progress"></div>


   <div class="owl-offer199 niki-11 owl-carousel">


                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>

 
<div class="product-list-1 ps3 jjj-112 lahze">

<a  href="<?php the_permalink(); ?>">
<div class="iranboximd"><div class="biowefwf34">
<?php the_post_thumbnail('woocommerce_thumbnail'); ?></div></div>
<h3><?php the_title(); ?></h3>


<div class="list-meta">
<span >

<span class="list-meta-2">

<div class="min-mike-6">

</span> 

<?php global $product; if( $product->is_on_sale() ) { ?>
<div class="daroffer-sepid mizan-sepid">

	<div class="offer-asli"><?php echo apply_filters( 'woocommerce_sale_flashtwo' , $product ); ?> تخفیف
</div>
</div>

<?php } ?>
<div class="risk-meta-price-98">
<?php global $product; echo $product->get_price_html(); ?></div>


</div>
</span>

</div></a>

</div>

                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       
            <?php endif;?>
<script>
//Init the carousel
initSlider();

function initSlider() {
  $(".owl-offer199").owlCarousel({
     loop:true,
     autoplay:true,
    autoplayTimeout:5000,
    autoplayHoverPause:true,
    rtl: true,
    nav:false,
	  onInitialized: startProgressBar,
    onTranslate: resetProgressBar,
    onTranslated: startProgressBar,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		   600:{
            items:1
        },
		   800 :{
            items:1
        },
        1200:{
            items:1
        },
        1300:{
            items:1
        }
    }
	  });

}

function startProgressBar() {
  // apply keyframe animation
  $(".slide-progress").css({
    width: "100%",
    transition: "width 5000ms"
  });
}

function resetProgressBar() {
  $(".slide-progress").css({
    width: 0,
    transition: "width 0s"
  });
}


</script>
        </div>      </div>  <div class="mobileform1"><div class="mob6ileform1"></div></div></div>  


        <?php

    }


}


