<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class productslidereight extends Widget_Base {

    public function get_name() {
        return 'productslidereight';
    }
    
    public function get_title() {
        return __( 'اسلایدر محصول 8', 'woolentor' );
    }


      public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => Wootar_woocommerce_product_categories(),
                ]
            );
           

          				       $this->add_control(
			'farnamoneshow7',
			[
				'label' => __( 'تکرار شوندگی در اسلایدر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		

        $this->end_controls_section();



         $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش تعداد دانشجو', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش نوع دوره', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
     
		       $this->add_control(
			'farnamoneshow4',
			[
				'label' => __( 'نمایش باکس پایین محصول', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
  
        $this->end_controls_section();

        
       
          $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
        
					    $this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه باکس', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .donyaproduct-cart1-2' => 'background: {{VALUE}} !important',
				],
			]
           );
			
			
				   	   $this->add_control(
                        'titr-124444-44r45rwtrt1',
                        [
                            'label' => __( 'سایه باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shttafdow1',
				'selector' => '{{WRAPPER}} .donyaproduct-cart1-2',
			]
		);
					    $this->add_control(
'sepidcolor-254',
			[
				'label' => __( 'رنگ باکس پایین محصولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .donyaproduct-cart1-1' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
	
					    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .title-new-boix-11' => 'color: {{VALUE}} !important',
				],
			]
           );
	
		       $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-six-home ins' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .price-six-home' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		     $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-six-home del' => 'color: {{VALUE}} !important',
				],
			]
           );
		
		    $this->add_control(
'sepidcolor-591',
			[
				'label' => __( 'رنگ پس زمینه ایکون تعداد دانشجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad144er i' => 'background: {{VALUE}} !important',
				],
			]
           );
			    $this->add_control(
'sepidcolor-592',
			[
				'label' => __( 'رنگ ایکون تعداد دانشجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad144er i' => 'color: {{VALUE}} !important',
				],
			]
           );
		  $this->add_control(
'sepidcolor-59244545',
			[
				'label' => __( 'رنگ متن تعداد دانشجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad144er' => 'color: {{VALUE}} !important',
				],
			]
           );
		
			    $this->add_control(
'sepidcolor-593',
			[
				'label' => __( 'رنگ پس زمینه نوع دوره', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad144dfr' => 'background: {{VALUE}} !important',
				],
			]
           );
		    $this->add_control(
'sepidcolor-594',
			[
				'label' => __( 'رنگ متن نوع دوره', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad144dfr' => 'color: {{VALUE}} !important',
				],
			]
           );
		
		   
		   
		   
		        $this->add_control(
'sepidcolor-598',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizan-tab-99-00' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		        $this->add_control(
'sepidcolor-599',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizan-tab-99-00' => 'color: {{VALUE}} !important',
				],
			]
           );
		     $this->add_control(
'sepidcolor-55555',
			[
				'label' => __( 'رنگ پس زمینه پیمایش اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-ssixxxq.owl-carousel.bxboxone.owl-rtl.owl-loaded .owl-nav button ' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-555r555',
			[
				'label' => __( 'رنگ ایکون پیمایش اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-ssixxxq.owl-carousel.bxboxone.owl-rtl.owl-loaded .owl-nav button ' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		
			
		
				/* گردی المان ها */
		
			   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .donyaproduct-cart1-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					  $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی باکس محصولات', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .donyaproduct-cart1-2' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						  $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی تصویر محصول', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .donyaproduct-cart1-2 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					$this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی ایکون تعداد دانشجو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-price-tedad144er i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
			
					
					$this->add_responsive_control(
                        'sepidborder-6',
                        [
                            'label' => esc_html__( 'گردی نوع دوره', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-price-tedad144dfr' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					$this->add_responsive_control(
                        'sepidborder-7',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mizan-tab-99-00' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						   $this->add_responsive_control(
                        'sepidborderrtg5-1',
                        [
                            'label' => esc_html__( 'گردی پیمایش اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .owl-ssixxxq.owl-carousel.bxboxone.owl-rtl.owl-loaded .owl-nav button ' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		        $this->end_controls_section();


        



        
	    
             

          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
    
        ];

        $slider_responsive_settings = [
           

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12donyaWss';
        }else{
            $collumval = 'product-listslide566-slidertwodonyaWss';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-listslide566-slidertwodonyaWss';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-listslide566-slidertwodonyaWss';
                }
            }
        }

        ?>
              
			
			           <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                $tabcatargs = array(
                    'orderby'    => 'name',
                    'order'      => 'ASC',
                    'hide_empty' => true,
                    'slug'       => $product_cats,
                );
                $tabcat_fach = get_terms( 'product_cat', $tabcatargs );
                foreach( $tabcat_fach as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    if( 'featured' == $product_type ){
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'featured',
                            'operator' => 'IN',
                        );
                    }
                    $products = new \WP_Query( $args );

                    if( $products->have_posts() ):
                    ?>
					
 
                <?php endif; endforeach;?>

            <?php else:?>
        <div class="ps2 product-style htpp sepidonya-111-2313555123498">
		

				<div class="left-donya-slider87i">

			<script>
			   $(document).ready(function(){
$('.owl-ssixxxq').owlCarousel({
   <?php if ( 'yes' === $settings['farnamoneshow7'] ) { ?>
   loop:true,<?php } ?>
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:0,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		  500:{
            items:2
        },
        900:{
            items:2
        },
        1200:{
            items:4
        }
    }
})
});
</script>
     


		                   <div class="owl-ssixxxq owl-carousel bxboxone">


                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
<div class="donyaproduct-cart1-1"><a href="<?php the_permalink(); ?>">
<div class="donyaproduct-cart1-2">
<?php the_post_thumbnail(''); ?>

<div class="title-new-boix-11">

<?php the_title(); ?>
</div>
<div class="price-six-home">
<div class="price-six-home1">

<?php global $product; echo $product->get_price_html(); ?>

</div>							<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>
<?php global $product; if ( $product->is_on_sale() ) : ?>


<div class="mizan-tab-99-00">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>


</div>
	<?php
endif;
?><?php } ?></div>
</div><?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?><div class="donyaproduct-cart1-3">
<?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
<div class="box-price-tedad144er">
<i class="fi fi-rr-graduation-cap"></i>
 <?php global $product;
$units_sold = get_post_meta( $product->get_id(), 'total_sales', true );
echo ''. sprintf( __( '%s', 'woocommerce' ), $units_sold ).''; ?> 

دانشجو</div><?php } ?><?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>

		<?php $option_meta = rwmb_meta('nodor'); if (!empty($option_meta)) { ?>

<div class="box-price-tedad144dfr"> <?php echo $option_meta; ?></div>
 <?php } ?>
<?php } ?>
</div> <?php } ?></a>
</div>

 



                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>     </div>       
            <?php endif;?>

        </div>  


        <?php

    }


}


