<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class productsliderten extends Widget_Base {

    public function get_name() {
        return 'productsliderten';
    }
    
    public function get_title() {
        return __( 'اسلایدر محصول 10', 'woolentor' );
    }


      public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => Wootar_woocommerce_product_categories(),
                ]
            );
           

          				       $this->add_control(
			'farnamoneshow7',
			[
				'label' => __( 'تکرار شوندگی در اسلایدر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		

        $this->end_controls_section();



         $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
  
		       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش نوع دوره', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
     
		       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش تایمر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
  
        $this->end_controls_section();

        
       
          $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
        
					    $this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه باکس', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-no-image-ten' => 'background: {{VALUE}} !important',
				],
			]
           );
			
			
				   	   $this->add_control(
                        'titr-124444-44r45rwtrt1',
                        [
                            'label' => __( 'سایه باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shttafdow1',
				'selector' => '{{WRAPPER}} .product-no-image-ten',
			]
		);
				
					    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-no-image-ten-2' => 'color: {{VALUE}} !important',
				],
			]
           );
	
		       $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .asdfsadf444prii676ce ins' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .asdfsadf444prii676ce' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		     $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .asdfsadf444prii676ce del' => 'color: {{VALUE}} !important',
				],
			]
           );
		    $this->add_control(
'sepidcolor-59',
			[
				'label' => __( 'رنگ نوع دوره', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad14476767' => 'color: {{VALUE}} !important',
				],
			]
           );
	  $this->add_control(
                        'titr-12-3w4',
                        [
                            'label' => __( 'رنگ پس زمینه تعداد دانشجو', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
					$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background1',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .box-price-tedad144rer.tenine-11212',
			]
		);
			    $this->add_control(
'sepidcolor-592',
			[
				'label' => __( 'رنگ متن تعداد دانشجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad144rer.tenine-11212' => 'color: {{VALUE}} !important',
				],
			]
           );
		
		

	
		   
		
		   

		        $this->add_control(
'sepidcolor-598',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-ergertg44 .mizan' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		        $this->add_control(
'sepidcolor-599',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-ergertg44 .mizan' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		        $this->add_control(
'sepidcolor-555599',
			[
				'label' => __( 'رنگ کادر جدا کننده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-timer-ten' => 'border-top-color: {{VALUE}} !important',
					'{{WRAPPER}} .product-no-image-ten-3' => 'border-bottom-color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   	        $this->add_control(
'sepidcolor-599rtrt',
			[
				'label' => __( 'رنگ شمارنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-timer-ten .timer-wrapper' => 'color: {{VALUE}} !important',
				],
			]
           );
		         $this->add_control(
'sepidcolor-599r56trt',
			[
				'label' => __( 'رنگ ثانیه شمار', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-timer-ten .timer-wrapper .mini-1-time' => 'color: {{VALUE}} !important',
				],
			]
           );
		     $this->add_control(
'sepidcolor-55555',
			[
				'label' => __( 'رنگ پس زمینه پیمایش اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-ssixxxten.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-555r555',
			[
				'label' => __( 'رنگ ایکون پیمایش اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-ssixxxten.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		
			
		
				/* گردی المان ها */
		
			   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-no-image-ten' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						  $this->add_responsive_control(
                        'sepidborder-3',
                        [
                            'label' => esc_html__( 'گردی میزان تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .price-ergertg44 .mizan' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					$this->add_responsive_control(
                        'sepidborder-4',
                        [
                            'label' => esc_html__( 'گردی تعداد دانشجو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-price-tedad144rer.tenine-11212' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
		
			
					
              
						   $this->add_responsive_control(
                        'sepidborderrtg5-1',
                        [
                            'label' => esc_html__( 'گردی پیمایش اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .owl-ssixxxten.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		        $this->end_controls_section();


        



        
	    
             

          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
    
        ];

        $slider_responsive_settings = [
           

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12donyaWten';
        }else{
            $collumval = 'product-listslide566-slidertwodonyaWten';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-listslide566-slidertwodonyaWten';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-listslide566-slidertwodonyaWten';
                }
            }
        }

        ?>
              
			
			           <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                $tabcatargs = array(
                    'orderby'    => 'name',
                    'order'      => 'ASC',
                    'hide_empty' => true,
                    'slug'       => $product_cats,
                );
                $tabcat_fach = get_terms( 'product_cat', $tabcatargs );
                foreach( $tabcat_fach as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    if( 'featured' == $product_type ){
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'featured',
                            'operator' => 'IN',
                        );
                    }
                    $products = new \WP_Query( $args );

                    if( $products->have_posts() ):
                    ?>
					
 
                <?php endif; endforeach;?>

            <?php else:?>
        <div class="ps2 product-style htpp sepidonya-111-23135551234ten">
		
	
				<div class="left-donya-slider8ten">

			<script>
			   $(document).ready(function(){
$('.owl-ssixxxten').owlCarousel({
   <?php if ( 'yes' === $settings['farnamoneshow7'] ) { ?>
   loop:true,<?php } ?>
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:0,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		  600:{
            items:2
        },
        950:{
            items:3
        },
        1200:{
            items:4
        }
    }
})
});
</script>
     


		                   <div class="owl-ssixxxten owl-carousel bxboxone">


                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
<div class="product-no-image-ten">
<a href="<?php the_permalink(); ?>">
<div class="product-no-image-ten-1">

<div class="product-no-image-ten-2">
<?php the_title(); ?>

</div>

<div class="product-no-image-ten-3">
<div class="box-price-tedad144rer tenine-11212">
<i class="fi fi-rr-graduation-cap"></i>
 <?php global $product;
$units_sold = get_post_meta( $product->get_id(), 'total_sales', true );
echo ''. sprintf( __( '%s', 'woocommerce' ), $units_sold ).''; ?> 

دانشجو
</div>
<?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

<?php $option_meta = rwmb_meta('nodor'); if (!empty($option_meta)) { ?>

<div class="box-price-tedad14476767"><?php echo $option_meta; ?></div><?php } ?><?php } ?>
</div>
<span class="price-ergertg44">
<?php if ( $product->is_on_sale() ) : ?>


<div class="mizan">
	<?php global $product; echo apply_filters( 'woocommerce_sale_flashtwo',  $product ); ?>


</div>
	<?php
endif;
?>
<div class="asdfsadf444prii676ce">
<?php global $product; echo $product->get_price_html(); ?>

	</div>

</span><?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>
<div class="price-timer-ten">

<div class="timer-offer-one56565656">

<?php global $product;
								if(  $product->is_on_sale() && $product->is_type('variable')){
?>
							<?php
				    global $post;
 // Variation ID
   $date="";
		    $sc_saving_pric = "";
			$sc_english_format_number = "";
            foreach($product->get_available_variations() as $variation ){
            $variation_id = $variation['variation_id'];
			            $sales_price_tot = get_post_meta( $variation_id, '_sale_price_dates_to', true );

								if(  $product->is_on_sale() && $sales_price_tot != "" && $product->is_type('variable')){
									
									
     
					?>
<?php global $post;

if ( ! $available_variations ) {
?>

	<?php
						if( $product->is_on_sale() && ! is_admin() && ! $product->is_type('variable')){
										$available_variations = $product->get_available_variations();

						}
		elseif($product->is_type('variable')){
		    $date="";
		    $sc_saving_pric = "";
			$sc_english_format_number = "";
            foreach($product->get_available_variations() as $variation ){
            // Variation ID
            $variation_id = $variation['variation_id'];
        // Prices
        $active_price = floatval($variation['display_price']); // Active price
        $regular_price = floatval($variation['display_regular_price']); // Regular Price
        if( $active_price != $regular_price ){
            $sale_price = $active_price; // Sale Price

            $meta_date = get_post_meta( $variation_id, '_sale_price_dates_to', true );
 $date1  .= 'display: block;';
            $sc_saving_pric .= $regular_price - $active_price;
			$sc_english_format_number .= number_format($sc_saving_pric);
        }





        }
						}
						
						  global $product;
	
		 
    if( $product->is_type('variable') ){
        $default_attributes = $product->get_default_attributes();
        foreach($product->get_available_variations() as $variation_values ){
            foreach($variation_values['attributes'] as $key => $attribute_value ){
                $attribute_name = str_replace( 'attribute_', '', $key );
                $default_value = $product->get_variation_default_attribute($attribute_name);
                if( $default_value == $attribute_value ){
                    $is_default_variation = true;
                } else {
                    $is_default_variation = false;
                    break; // Stop this loop to start next main lopp
                }
            }
            if( $is_default_variation ){
                $variation_id = $variation_values['variation_id'];
                break; // Stop the main loop
		
            }
        }
		
		
        if( $is_default_variation ){
            // Raw output of available "default" variation details data
		 $meta_date = get_post_meta( $variation_id, '_sale_price_dates_to', true );
					if( empty( $meta_date ) ){
																//	echo esc_html_e( 'زمان بندی پیشنهاد ویژه تعیین نشده است!', 'studiare' );
															}
          	else{
					$date  = date( 'm/d/Y 23:59', $meta_date );//echo $date;
			}
		
								if( empty( $meta_date ) ){
								}
								else{
	
						   ?>
						

<div class="sepid-offer-401-new">
 
<div class="sepid-offer-401-new-box">
<div id="sp1<?php echo get_the_ID(); ?>"></div>
<script type="text/javascript">
 $('#sp1<?php echo get_the_ID(); ?>').countdown('<?php echo esc_attr( $date ) ?> 23:59', function(event) {
  var $this = $(this).html(event.strftime(''
    + '<div class="timer-wrapper"><div class="time1">%D</div><span class="text32">روز</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%H</div><span class="text32">ساعت</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%M</div><span class="text32">دقیقه</span></div>'
    + '<div class="timer-wrapper"><div class="time1 mini-1-time">%S</div><span class="text32 text34">ثانیه</span></div>'
));
});
</script>

</div>

</div>
						


<?php }
			}
								}	}	}}}
					?>
					
  <?php
					global $post;

  $sales_price_to = get_post_meta($post->ID, '_sale_price_dates_to', true);
  

    if (  $sales_price_to != "" ) {      


 
					?>	
<div class="sepid-offer-401-new">

<div class="sepid-offer-401-new-box">
<div id="sp1<?php echo get_the_ID(); ?>"></div>
<script type="text/javascript">
 $('#sp1<?php echo get_the_ID(); ?>').countdown('<?php echo do_shortcode( '[display_end_date]' ); ?> 23:59', function(event) {
  var $this = $(this).html(event.strftime(''
    + '<div class="timer-wrapper"><div class="time1">%D</div><span class="text32">روز</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%H</div><span class="text32">ساعت</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%M</div><span class="text32">دقیقه</span></div>'
    + '<div class="timer-wrapper"><div class="time1 mini-1-time"> %S</div><span class="text32 text34">ثانیه</span></div>'
));
});
</script>

</div>

</div><?php }
					
					?>
					
					</div>
					</div><?php } ?>
</div></a>
</div>

 



                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>     </div>       
            <?php endif;?>

        </div>  


        <?php

    }


}


