<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class productslidertwo extends Widget_Base {

    public function get_name() {
        return 'productslidertwo';
    }
    
    public function get_title() {
        return __( 'اسلایدر محصول 2', 'woolentor' );
    }


      public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => Wootar_woocommerce_product_categories(),
                ]
            );
           

          				       $this->add_control(
			'farnamoneshow7',
			[
				'label' => __( 'تکرار شوندگی در اسلایدر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		

        $this->end_controls_section();

       
          $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
        
					    $this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه باکس', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .boz-slider-twi-401-1' => 'background: {{VALUE}} !important',
				],
			]
           );
			
			
				   	   $this->add_control(
                        'titr-124444-44r45rwtrt1',
                        [
                            'label' => __( 'سایه باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shttafdow1',
				'selector' => '{{WRAPPER}} .boz-slider-twi-401-1',
			]
		);
		
			
					    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-slider-two-401-4 h4' => 'color: {{VALUE}} !important',
				],
			]
           );
		    $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ المان کنار عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-slider-two-401-4 h4::before' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		       $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .pricve-rree ins' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .pricve-rree' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		     $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .pricve-rree del' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   /* استایل تصویر و المان */
		   
		    $this->add_control(
                        'titr-12-3w4',
                        [
                            'label' => __( 'رنگ پس زمینه اولیه تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
					$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background1',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .boz-slider-twi-401-2',
			]
		);
					   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'رنگ سایه تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .boz-slider-twi-401-2',
			]
		);
					
						          $this->add_control(
'sepidcolor-11',
			[
				'label' => __( 'رنگ پس زمینه ثانویه تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .boz-slider-twi-401-3' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		    /* استایل المان کنار عنوان اصلی */
		    $this->add_control(
                        'titr-12-3w41',
                        [
                            'label' => __( 'پس زمینه المان کنار باکس', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
					$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background11',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .boz-slider-twi-401-1::before',
			]
		);
					   	   $this->add_control(
                        'titr-124444-44r45rw1',
                        [
                            'label' => __( 'سایه المان کنار باکس', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shafdow1',
				'selector' => '{{WRAPPER}} .boz-slider-twi-401-1::before',
			]
		);
		
		
		
		     $this->add_control(
'sepidcolor-55555',
			[
				'label' => __( 'رنگ پس زمینه پیمایش اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-slidetwo.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-555r555',
			[
				'label' => __( 'رنگ ایکون پیمایش اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-slidetwo.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		
				   	   $this->add_control(
                        'titr-124444-44r45rwtererrt1',
                        [
                            'label' => __( 'سایه پیمایش اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shttertafdow1',
				'selector' => '{{WRAPPER}} .owl-slidetwo.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button',
			]
		);
		
		
		
				/* گردی المان ها */
		
			   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .boz-slider-twi-401-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					  $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .boz-slider-twi-401-2' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .boz-slider-twi-401-3' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .boz-slider-twi-401-3 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
						   $this->add_responsive_control(
                        'sepidborderrtg5-1',
                        [
                            'label' => esc_html__( 'گردی پیمایش اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .owl-slidetwo.owl-carousel.bxboxone.owl-rtl.owl-loaded.owl-drag .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		        $this->end_controls_section();


        



        
	    
             

          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
    
        ];

        $slider_responsive_settings = [
           

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-listslide566-slidertwo';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-listslide566-slidertwo';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-listslide566-slidertwo';
                }
            }
        }

        ?>
              
			
			           <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                $tabcatargs = array(
                    'orderby'    => 'name',
                    'order'      => 'ASC',
                    'hide_empty' => true,
                    'slug'       => $product_cats,
                );
                $tabcat_fach = get_terms( 'product_cat', $tabcatargs );
                foreach( $tabcat_fach as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    if( 'featured' == $product_type ){
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'featured',
                            'operator' => 'IN',
                        );
                    }
                    $products = new \WP_Query( $args );

                    if( $products->have_posts() ):
                    ?>
					
 
                <?php endif; endforeach;?>

            <?php else:?>
        <div class="ps2 product-style htpp sepid-111-2313555">
			<script>
			   $(document).ready(function(){
$('.owl-slidetwo').owlCarousel({
   <?php if ( 'yes' === $settings['farnamoneshow7'] ) { ?>
   loop:true,<?php } ?>
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:0,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		  600:{
            items:2
        },
        900:{
            items:2
        },
        1200:{
            items:3
        }
    }
})
});
</script>
     


		                   <div class="owl-slidetwo owl-carousel bxboxone">


                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
<div class="boz-slider-twi-401">
<a href="<?php the_permalink(); ?>">
<div class="boz-slider-twi-401-1">
<div class="boz-slider-twi-401-2">
<div class="boz-slider-twi-401-3">
<?php the_post_thumbnail('woocommerce_thumbnail'); ?>

</div>
</div>
<div class="box-slider-two-401-4">
<h4><?php the_title(); ?>  	</h4>
<div class="pricve-rree">
<?php global $product; echo $product->get_price_html(); ?>

</div>
</div>
</div></a>
</div>
 



                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       
            <?php endif;?>

        </div>  


        <?php

    }


}


