<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 7.8.0
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'woocommerce-product-gallery--' . ( $product->get_image_id() ? 'with-images' : 'without-images' ),
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );
?>

<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
		

		
		<div class="product-meta-sepid">
<div class="meta-one-sepi">
		     <?php if((get_option('farnamfour6') == true )): ?>

<div class="meta-v-sopid-box">
<div class="tooltip-meta-v-sepid">علاقه مندی</div>
<?php echo do_shortcode( '[yith_wcwl_add_to_wishlist product_id=' . get_the_ID() . ']' ); ?>

</div>

<?php endif; ?>
		     <?php if((get_option('farnamfour7') == true )): ?>

<div class="meta-v-sopid-box">
<div class="tooltip-meta-v-sepid">مقایسه محصول</div>

<?php echo do_shortcode( '[woosc id=' . get_the_ID() . ']' ); ?>
</div><?php endif; ?>
		     <?php if((get_option('farnamfour8') == true )): ?>

<button id="shareb" class="meta-v-sopid-box">
<div class="tooltip-meta-v-sepid">اشتراک گذاری</div>

<i class="fi fi-rr-share"></i>
</button>
<?php endif; ?>
</div>
<?php $option_meta = rwmb_meta('videol'); if (!empty($option_meta)) { ?>

<button id="videob" class="meta-one-sepi-video meta-v-sopid-box">
<div class="tooltip-meta-v-sepid">ویدیو محصول</div>

<i class="fi fi-rr-play"></i>

</button><?php } ?>
<script>
<?php $option_meta = rwmb_meta('videol'); if (!empty($option_meta)) { ?>

// Get the modal
var modal = document.getElementById("videom");

// Get the button that opens the modal
var btn = document.getElementById("videob");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks on the button, open the modal
btn.onclick = function() {
  modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
} <?php } ?>
		     <?php if((get_option('farnamfour8') == true )): ?>


// Get the modal
var modal1 = document.getElementById("sharem");

// Get the button that opens the modal
var btn = document.getElementById("shareb");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close1")[0];

// When the user clicks on the button, open the modal
btn.onclick = function() {
  modal1.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal1.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal1) {
    modal1.style.display = "none";
  }
} <?php endif; ?>

</script>


</div>
	
	
	<figure class="woocommerce-product-gallery__wrapper">

		<?php
		if ( $product->get_image_id() ) {
			$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
		} else {
			$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
			$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
			$html .= '</div>';
		}

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped

		do_action( 'woocommerce_product_thumbnails' );
		?>
	</figure>
</div>
